{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 1995-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

{*******************************************************}
{       OLEDB Interface Unit                            }
{*******************************************************}

unit Borland.Vcl.OleDB;

interface

uses Windows, ActiveX, Variants, System.Runtime.InteropServices;

// *********************************************************************//
// GUID declarations                                                    //
// *********************************************************************//
const
  CLSID_OLEDB_ENUMERATOR{: TGUID} = '{C8B522D0-5CF3-11CE-ADE5-00AA0044773D}'; {MSDAENUM}
  CLSID_EXTENDEDERRORINFO{: TGUID} = '{C8B522CF-5CF3-11CE-ADE5-00AA0044773D}'; {MSDAERR}
  CLSID_MSDAVTM{: TGUID} = '{0C733A8E-2A1C-11CE-ADE5-00AA0044773D}'; {MSDAVTM}
  CLSID_OLEDB_CONVERSIONLIBRARY{: TGUID} = '{C8B522D1-5CF3-11CE-ADE5-00AA0044773D}'; {MSDADC}
  CLSID_OLEDB_ROWPOSITIONLIBRARY{: TGUID} = '{2048EEE6-7FA2-11D0-9E6A-00A0C9138C29}'; {RowPosition.RowPosition}
  CLSID_DATALINKS{: TGUID} = '{2206CDB2-19C1-11D1-89E0-00C04FD7A829}'; {DataLinks}

  IID_ITransaction{: TGUID} = '{0FB15084-AF41-11CE-BD2B-204C4F4F5020}';
  IID_ITransactionOptions{: TGUID} = '{3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD}';
  IID_ITransactionDispenser{: TGUID} = '{3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD}';
  IID_ITransactionOutcomeEvents{: TGUID} = '{3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD}';
  IID_IAccessor{: TGUID} = '{0C733A8C-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowset{: TGUID} = '{0C733A7C-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetInfo{: TGUID} = '{0C733A55-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetLocate{: TGUID} = '{0C733A7D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetResynch{: TGUID} = '{0C733A84-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetScroll{: TGUID} = '{0C733A7E-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetChange{: TGUID} = '{0C733A05-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetUpdate{: TGUID} = '{0C733A6D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetIndex{: TGUID} = '{0C733A82-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IMultipleResults{: TGUID} = '{0C733A90-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IConvertType{: TGUID} = '{0C733A88-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandPrepare{: TGUID} = '{0C733A26-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandProperties{: TGUID} = '{0C733A79-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommand{: TGUID} = '{0C733A63-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandWithParameters{: TGUID} = '{0C733A10-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandText{: TGUID} = '{0C733A27-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IColumnsRowset{: TGUID} = '{0C733A10-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IColumnsInfo{: TGUID} = '{0C733A11-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBCreateCommand{: TGUID} = '{0C733A1D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBCreateSession{: TGUID} = '{0C733A5D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISourcesRowset{: TGUID} = '{0C733A1E-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBProperties{: TGUID} = '{0C733A8A-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBInitialize{: TGUID} = '{0C733A8B-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBInfo{: TGUID} = '{0C733A89-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBDataSourceAdmin{: TGUID} = '{0C733A7A-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISessionProperties{: TGUID} = '{0C733A85-2A1C-11CE-ADE5-00AA0044773d}';
  IID_IIndexDefinition{: TGUID} = '{0C733A68-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITableDefinition{: TGUID} = '{0C733A86-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IOpenRowset{: TGUID} = '{0C733A69-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IErrorLookup{: TGUID} = '{0C733A66-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISQLErrorInfo{: TGUID} = '{0C733A74-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IGetDataSource{: TGUID} = '{0C733A75-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITransactionLocal{: TGUID} = '{0C733A5F-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITransactionJoin{: TGUID} = '{0C733A5E-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITransactionObject{: TGUID} = '{0C733A60-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBAsynchStatus{: TGUID} = '{0C733A95-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetFind{: TGUID} = '{0C733A9D-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowPosition{: TGUID} = '{0C733A94-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowPositionChange{: TGUID} = '{0997A571-126E-11D0-9F8A-00A0C9A0631E}';
  IID_IViewRowset{: TGUID} = '{0C733A97-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IViewChapter{: TGUID} = '{0C733A98-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IViewSort{: TGUID} = '{0C733A9A-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IViewFilter{: TGUID} = '{0C733A9B-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetView{: TGUID} = '{0C733A99-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IMDFind{: TGUID} = '{A07CCCD2-8148-11D0-87BB-00C04FC33942}';
  IID_IMDRangeRowset{: TGUID} = '{0C733AA0-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IAlterTable{: TGUID} = '{0C733AA5-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IAlterIndex{: TGUID} = '{0C733AA6-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ICommandPersist{: TGUID} = '{0C733AA7-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetChapterMember{: TGUID} = '{0C733AA8-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IRowsetRefresh{: TGUID} = '{0C733AA9-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IParentRowset{: TGUID} = '{0C733AAA-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ITrusteeGroupAdmin{: TGUID} = '{0C733AA2-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IObjectAccessControl{: TGUID} = '{0C733AA3-2A1C-11CE-ADE5-00AA0044773D}';
  IID_ISecurityInfo{: TGUID} = '{0C733AA4-2A1C-11CE-ADE5-00AA0044773D}';
  IID_IDBPromptInitialize{: TGUID} = '{2206CCB0-19C1-11D1-89E0-00C04FD7A829}';
  IID_IDataInitialize{: TGUID} = '{2206CCB1-19C1-11D1-89E0-00C04FD7A829}';

  DBSCHEMA_TABLES_INFO{: TGUID} = '{C8B522E0-5CF3-11CE-ADE5-00AA0044773D}';
  MDGUID_MDX{: TGUID} = '{A07CCCD0-8148-11D0-87BB-00C04FC33942}';
  DBGUID_MDX{: TGUID} = '{A07CCCD0-8148-11D0-87BB-00C04FC33942}';
  MDSCHEMA_CUBES{: TGUID} = '{C8B522D8-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_DIMENSIONS{: TGUID} = '{C8B522D9-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_HIERARCHIES{: TGUID} = '{C8B522DA-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_LEVELS{: TGUID} = '{C8B522DB-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_MEASURES{: TGUID} = '{C8B522DC-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_PROPERTIES{: TGUID} = '{C8B522DD-5CF3-11CE-ADE5-00AA0044773D}';
  MDSCHEMA_MEMBERS{: TGUID} = '{C8B522DE-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TRUSTEE{: TGUID} = '{C8B522E1-5CF3-11CE-ADE5-00AA0044773D}';

  DBOBJECT_TABLE{: TGUID} = '{C8B522E2-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_COLUMN{: TGUID} = '{C8B522E4-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_DATABASE{: TGUID} = '{C8B522E5-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_PROCEDURE{: TGUID} = '{C8B522E6-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_VIEW{: TGUID} = '{C8B522E7-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_SCHEMA{: TGUID} = '{C8B522E8-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_DOMAIN{: TGUID} = '{C8B522E9-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_COLLATION{: TGUID} = '{C8B522EA-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_TRUSTEE{: TGUID} = '{C8B522EB-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_SCHEMAROWSET{: TGUID} = '{C8B522EC-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_CHARACTERSET{: TGUID} = '{C8B522ED-5CF3-11CE-ADE5-00AA0044773D}';
  DBOBJECT_TRANSLATION{: TGUID} = '{C8B522EE-5CF3-11CE-ADE5-00AA0044773D}';

  DB_PROPERTY_CHECK_OPTION{: TGUID} = '{C8B5220B-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_CONSTRAINT_CHECK_DEFERRED{: TGUID} = '{C8B521F0-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_DROP_CASCADE{: TGUID} = '{C8B521F3-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_UNIQUE{: TGUID} = '{C8B521F5-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS{: TGUID} = '{C8B52230-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_PRIMARY{: TGUID} = '{C8B521FC-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_CLUSTERED{: TGUID} = '{C8B521FF-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_NONCLUSTERED{: TGUID} = '{C8B52200-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_BTREE{: TGUID} = '{C8B52201-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_HASH{: TGUID} = '{C8B52202-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_FILLFACTOR{: TGUID} = '{C8B52203-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_INITIALSIZE{: TGUID} = '{C8B52204-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_DISALLOWNULL{: TGUID} = '{C8B52205-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_IGNORENULL{: TGUID} = '{C8B52206-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_IGNOREANYNULL{: TGUID} = '{C8B52207-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_SORTBOOKMARKS{: TGUID} = '{C8B52208-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_AUTOMATICUPDATE{: TGUID} = '{C8B52209-5CF3-11CE-ADE5-00AA0044773D}';
  DB_PROPERTY_EXPLICITUPDATE{: TGUID} = '{C8B5220A-5CF3-11CE-ADE5-00AA0044773D}';

  DBGUID_LIKE_SQL{: TGUID} = '{C8B521F6-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_LIKE_DOS{: TGUID} = '{C8B521F7-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_LIKE_OFS{: TGUID} = '{C8B521F8-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_LIKE_MAPI{: TGUID} = '{C8B521F9-5CF3-11CE-ADE5-00AA0044773D}';

  DBSCHEMA_ASSERTIONS{: TGUID} = '{C8B52210-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CATALOGS{: TGUID} = '{C8B52211-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CHARACTER_SETS{: TGUID} = '{C8B52212-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLLATIONS{: TGUID} = '{C8B52213-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLUMNS{: TGUID} = '{C8B52214-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CHECK_CONSTRAINTS{: TGUID} = '{C8B52215-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CONSTRAINT_COLUMN_USAGE{: TGUID} = '{C8B52216-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_CONSTRAINT_TABLE_USAGE{: TGUID} = '{C8B52217-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_KEY_COLUMN_USAGE{: TGUID} = '{C8B52218-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_REFERENTIAL_CONSTRAINTS{: TGUID} = '{C8B52219-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TABLE_CONSTRAINTS{: TGUID} = '{C8B5221A-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLUMN_DOMAIN_USAGE{: TGUID} = '{C8B5221B-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_INDEXES{: TGUID} = '{C8B5221E-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_COLUMN_PRIVILEGES{: TGUID} = '{C8B52221-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TABLE_PRIVILEGES{: TGUID} = '{C8B52222-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_USAGE_PRIVILEGES{: TGUID} = '{C8B52223-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROCEDURES{: TGUID} = '{C8B52224-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_SCHEMATA{: TGUID} = '{C8B52225-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_SQL_LANGUAGES{: TGUID} = '{C8B52226-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_STATISTICS{: TGUID} = '{C8B52227-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TABLES{: TGUID} = '{C8B52229-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_TRANSLATIONS{: TGUID} = '{C8B5222A-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROVIDER_TYPES{: TGUID} = '{C8B5222C-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_VIEWS{: TGUID} = '{C8B5222D-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_VIEW_COLUMN_USAGE{: TGUID} = '{C8B5222E-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_VIEW_TABLE_USAGE{: TGUID} = '{C8B5222F-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROCEDURE_PARAMETERS{: TGUID} = '{C8B522B8-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_FOREIGN_KEYS{: TGUID} = '{C8B522C4-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PRIMARY_KEYS{: TGUID} = '{C8B522C5-5CF3-11CE-ADE5-00AA0044773D}';
  DBSCHEMA_PROCEDURE_COLUMNS{: TGUID} = '{C8B522C9-5CF3-11CE-ADE5-00AA0044773D}';

  DBCOL_SELFCOLUMNS{: TGUID} = '{C8B52231-5CF3-11CE-ADE5-00AA0044773D}';
  DBCOL_SPECIALCOL{: TGUID} = '{C8B52232-5CF3-11CE-ADE5-00AA0044773D}';
  PSGUID_QUERY{: TGUID} = '{49691C90-7E17-101A-A91C-08002B2ECDA9}';

  DBPROPSET_COLUMN{: TGUID} = '{C8B522B9-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCE{: TGUID} = '{C8B522BA-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCEINFO{: TGUID} = '{C8B522BB-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_INDEX{: TGUID} = '{C8B522BD-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DBINIT{: TGUID} = '{C8B522BC-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_ROWSET{: TGUID} = '{C8B522BE-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_SESSION{: TGUID} = '{C8B522C6-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TABLE{: TGUID} = '{C8B522BF-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_PROPERTIESINERROR{: TGUID} = '{C8B522D4-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_VIEW{: TGUID} = '{C8B522DF-5CF3-11CE-ADE5-00AA0044773D}';

  DBPROPSET_COLUMNALL = '{C8B522F0-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_CONSTRAINTALL = '{C8B522FA-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCEALL{: TGUID} = '{C8B522C0-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DATASOURCEINFOALL{: TGUID} = '{C8B522C1-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_DBINITALL{: TGUID} = '{C8B522CA-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_INDEXALL = '{C8B522F1-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_ROWSETALL{: TGUID} = '{C8B522C2-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_SESSIONALL{: TGUID} = '{C8B522C7-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TABLEALL = '{C8B522F2-5CF3-11CE-ADE5-00AA0044773D}';
  DBPROPSET_TRUSTEEALL = '{C8B522F3-5CF3-11CE-ADE5-00AA0044773D}';


  DBGUID_DEFAULT{: TGUID} = '{C8B521FB-5CF3-11CE-ADE5-00AA0044773D}';
  DBGUID_SQL{: TGUID} = '{C8B522D7-5CF3-11CE-ADE5-00AA0044773D}';

// *********************************************************************//
// Constant Declarations                                                //
// *********************************************************************//

const
  MAXCOLS = 4096;
  MAXBOUND = 65535; { High bound for arrays }
  OLEDBVER = $0210;
  DB_INVALID_HACCESSOR = $00;
  DB_NULL_HROW = $00;
  DBWATCHREGION_NULL = nil;
  DB_NULL_HCHAPTER = $00;
  STD_BOOKMARKLENGTH = 1;
  DB_INVALIDCOLUMN = HIGH(ULONG);
  DBCIDGUID{: TGUID} = '{0C733A81-2A1C-11CE-ADE5-00AA0044773D}';
  DB_NULLGUID{: TGUID} = '{00000000-0000-0000-0000-000000000000}';
  DBPROPVAL_BMK_NUMERIC = $00000001;
  DBPROPVAL_BMK_KEY = $00000002;
  DBPROPVAL_CL_START = $00000001;
  DBPROPVAL_CL_END = $00000002;
  DBPROPVAL_CU_DML_STATEMENTS = $00000001;
  DBPROPVAL_CU_TABLE_DEFINITION = $00000002;
  DBPROPVAL_CU_INDEX_DEFINITION = $00000004;
  DBPROPVAL_CU_PRIVILEGE_DEFINITION = $00000008;
  DBPROPVAL_CD_NOTNULL = $00000001;
  DBPROPVAL_CB_NULL = $00000001;
  DBPROPVAL_CB_NON_NULL = $00000002;
  DBPROPVAL_FU_NOT_SUPPORTED = $00000001;
  DBPROPVAL_FU_COLUMN = $00000002;
  DBPROPVAL_FU_TABLE = $00000004;
  DBPROPVAL_FU_CATALOG = $00000008;
  DBPROPVAL_GB_NOT_SUPPORTED = $00000001;
  DBPROPVAL_GB_EQUALS_SELECT = $00000002;
  DBPROPVAL_GB_CONTAINS_SELECT = $00000004;
  DBPROPVAL_GB_NO_RELATION = $00000008;
  DBPROPVAL_HT_DIFFERENT_CATALOGS = $00000001;
  DBPROPVAL_HT_DIFFERENT_PROVIDERS = $00000002;
  DBPROPVAL_IC_UPPER = $00000001;
  DBPROPVAL_IC_LOWER = $00000002;
  DBPROPVAL_IC_SENSITIVE = $00000004;
  DBPROPVAL_IC_MIXED = $00000008;
  DBPROPVAL_LM_NONE = $00000001;
  DBPROPVAL_LM_READ = $00000002;
  DBPROPVAL_LM_INTENT = $00000004;
  DBPROPVAL_LM_RITE = $00000008;
  DBPROPVAL_NP_OKTODO = $00000001;
  DBPROPVAL_NP_ABOUTTODO = $00000002;
  DBPROPVAL_NP_SYNCHAFTER = $00000004;
  DBPROPVAL_NP_FAILEDTODO = $00000008;
  DBPROPVAL_NP_DIDEVENT = $00000010;
  DBPROPVAL_NC_END = $00000001;
  DBPROPVAL_NC_HIGH = $00000002;
  DBPROPVAL_NC_LOW = $00000004;
  DBPROPVAL_NC_START = $00000008;
  DBPROPVAL_OO_BLOB = $00000001;
  DBPROPVAL_OO_IPERSIST = $00000002;
  DBPROPVAL_CB_DELETE = $00000001;
  DBPROPVAL_CB_PRESERVE = $00000002;
  DBPROPVAL_SU_DML_STATEMENTS = $00000001;
  DBPROPVAL_SU_TABLE_DEFINITION = $00000002;
  DBPROPVAL_SU_INDEX_DEFINITION = $00000004;
  DBPROPVAL_SU_PRIVILEGE_DEFINITION = $00000008;
  DBPROPVAL_SQ_CORRELATEDSUBQUERIES = $00000001;
  DBPROPVAL_SQ_COMPARISON = $00000002;
  DBPROPVAL_SQ_EXISTS = $00000004;
  DBPROPVAL_SQ_IN = $00000008;
  DBPROPVAL_SQ_QUANTIFIED = $00000010;
  DBPROPVAL_SS_ISEQUENTIALSTREAM = $00000001;
  DBPROPVAL_SS_ISTREAM = $00000002;
  DBPROPVAL_SS_ISTORAGE = $00000004;
  DBPROPVAL_SS_ILOCKBYTES = $00000008;
  DBPROPVAL_TI_CHAOS = $00000010;
  DBPROPVAL_TI_READUNCOMMITTED = $00000100;
  DBPROPVAL_TI_BROWSE = $00000100;
  DBPROPVAL_TI_CURSORSTABILITY = $00001000;
  DBPROPVAL_TI_READCOMMITTED = $00001000;
  DBPROPVAL_TI_REPEATABLEREAD = $00010000;
  DBPROPVAL_TI_SERIALIZABLE = $00100000;
  DBPROPVAL_TI_ISOLATED = $00100000;
  DBPROPVAL_TR_COMMIT_DC = $00000001;
  DBPROPVAL_TR_COMMIT = $00000002;
  DBPROPVAL_TR_COMMIT_NO = $00000004;
  DBPROPVAL_TR_ABORT_DC = $00000008;
  DBPROPVAL_TR_ABORT = $00000010;
  DBPROPVAL_TR_ABORT_NO = $00000020;
  DBPROPVAL_TR_DONTCARE = $00000040;
  DBPROPVAL_TR_BOTH = $00000080;
  DBPROPVAL_TR_NONE = $00000100;
  DBPROPVAL_TR_OPTIMISTIC = $00000200;
  DBPROPVAL_RT_FREETHREAD = $00000001;
  DBPROPVAL_RT_APTMTTHREAD = $00000002;
  DBPROPVAL_RT_SINGLETHREAD = $00000004;
  DBPROPVAL_UP_CHANGE = $00000001;
  DBPROPVAL_UP_DELETE = $00000002;
  DBPROPVAL_UP_INSERT = $00000004;
  DBPROPVAL_SQL_NONE = $00000000;
  DBPROPVAL_SQL_ODBC_MINIMUM = $00000001;
  DBPROPVAL_SQL_ODBC_CORE = $00000002;
  DBPROPVAL_SQL_ODBC_EXTENDED = $00000004;
  DBPROPVAL_SQL_ANSI89_IEF = $00000008;
  DBPROPVAL_SQL_ANSI92_ENTRY = $00000010;
  DBPROPVAL_SQL_FIPS_TRANSITIONAL = $00000020;
  DBPROPVAL_SQL_ANSI92_INTERMEDIATE = $00000040;
  DBPROPVAL_SQL_ANSI92_FULL = $00000080;
  DBPROPVAL_SQL_ESCAPECLAUSES = $00000100;
  DBPROPVAL_IT_BTREE = $00000001;
  DBPROPVAL_IT_HASH = $00000002;
  DBPROPVAL_IT_CONTENT = $00000003;
  DBPROPVAL_IT_OTHER = $00000004;
  DBPROPVAL_IN_DISALLOWNULL = $00000001;
  DBPROPVAL_IN_IGNORENULL = $00000002;
  DBPROPVAL_IN_IGNOREANYNULL = $00000004;
  DBPROPVAL_TC_NONE = $00000000;
  DBPROPVAL_TC_DML = $00000001;
  DBPROPVAL_TC_DDL_COMMIT = $00000002;
  DBPROPVAL_TC_DDL_IGNORE = $00000004;
  DBPROPVAL_TC_ALL = $00000008;
  DBPROPVAL_OA_NOTSUPPORTED = $00000001;
  DBPROPVAL_OA_ATEXECUTE = $00000002;
  DBPROPVAL_OA_ATROWRELEASE = $00000004;
  DBPROPVAL_MR_NOTSUPPORTED = $00000000;
  DBPROPVAL_MR_SUPPORTED = $00000001;
  DBPROPVAL_MR_CONCURRENT = $00000002;
  DBPROPVAL_PT_GUID_NAME = $00000001;
  DBPROPVAL_PT_GUID_PROPID = $00000002;
  DBPROPVAL_PT_NAME = $00000004;
  DBPROPVAL_PT_GUID = $00000008;
  DBPROPVAL_PT_PROPID = $00000010;
  DBPROPVAL_PT_PGUID_NAME = $00000020;
  DBPROPVAL_PT_PGUID_PROPID = $00000040;
  DBPROPVAL_NT_SINGLEROW = $00000001;
  DBPROPVAL_NT_MULTIPLEROWS = $00000002;
  DBPROPVAL_ASYNCH_INITIALIZE = $00000001;
  DBPROPVAL_ASYNCH_SEQUENTIALPOPULATION = $00000002;
  DBPROPVAL_ASYNCH_RANDOMPOPULATION = $00000004;
  DBPROPVAL_OP_EQUAL = $00000001;
  DBPROPVAL_OP_RELATIVE = $00000002;
  DBPROPVAL_OP_STRING = $00000004;
  DBPROPVAL_CO_EQUALITY = $00000001;
  DBPROPVAL_CO_STRING = $00000002;
  DBPROPVAL_CO_CASESENSITIVE = $00000004;
  DBPROPVAL_CO_CASEINSENSITIVE = $00000008;
  DBPROPVAL_CO_CONTAINS = $00000010;
  DBPROPVAL_CO_BEGINSWITH = $00000020;
  DBPROPVAL_ASYNCH_BACKGROUNDPOPULATION = $00000008;
  DBPROPVAL_ASYNCH_PREPOPULATE = $00000010;
  DBPROPVAL_ASYNCH_POPULATEONDEMAND = $00000020;
  DBPROPVAL_LM_SINGLEROW = $00000002;
  DBPROPVAL_SQL_SUBMINIMUM = $00000200;
  DBPROPVAL_DST_TDP = $00000001;
  DBPROPVAL_DST_MDP = $00000002;
  DBPROPVAL_DST_TDPANDMDP = $00000003;
  MDPROPVAL_AU_UNSUPPORTED = $00000000;
  MDPROPVAL_AU_UNCHANGED = $00000001;
  MDPROPVAL_AU_UNKNOWN = $00000002;
  MDPROPVAL_MF_WITH_CALCMEMBERS = $00000001;
  MDPROPVAL_MF_WITH_NAMEDSETS = $00000002;
  MDPROPVAL_MF_CREATE_CALCMEMBERS = $00000004;
  MDPROPVAL_MF_CREATE_NAMEDSETS = $00000008;
  MDPROPVAL_MF_SCOPE_SESSION = $00000010;
  MDPROPVAL_MF_SCOPE_GLOBAL = $00000020;
  MDPROPVAL_MMF_COUSIN = $00000001;
  MDPROPVAL_MMF_PARALLELPERIOD = $00000002;
  MDPROPVAL_MMF_OPENINGPERIOD = $00000004;
  MDPROPVAL_MMF_CLOSINGPERIOD = $00000008;
  MDPROPVAL_MNF_MEDIAN = $00000001;
  MDPROPVAL_MNF_VAR = $00000002;
  MDPROPVAL_MNF_STDDEV = $00000004;
  MDPROPVAL_MNF_RANK = $00000008;
  MDPROPVAL_MNF_AGGREGATE = $00000010;
  MDPROPVAL_MNF_COVARIANCE = $00000020;
  MDPROPVAL_MNF_CORRELATION = $00000040;
  MDPROPVAL_MNF_LINREGSLOPE = $00000080;
  MDPROPVAL_MNF_LINREGVARIANCE = $00000100;
  MDPROPVAL_MNF_LINREG2 = $00000200;
  MDPROPVAL_MNF_LINREGPOINT = $00000400;
  MDPROPVAL_MNF_DRILLDOWNLEVEL = $00000800;
  MDPROPVAL_MNF_DRILLDOWNMEMBERTOP = $00001000;
  MDPROPVAL_MNF_DRILLDOWNMEMBERBOTTOM = $00002000;
  MDPROPVAL_MNF_DRILLDOWNLEVELTOP = $00004000;
  MDPROPVAL_MNF_DRILLDOWNLEVELBOTTOM = $00008000;
  MDPROPVAL_MNF_DRILLUPMEMBER = $00010000;
  MDPROPVAL_MNF_DRILLUPLEVEL = $00020000;
  MDPROPVAL_MSF_TOPPERCENT = $00000001;
  MDPROPVAL_MSF_BOTTOMPERCENT = $00000002;
  MDPROPVAL_MSF_TOPSUM = $00000004;
  MDPROPVAL_MSF_BOTTOMSUM = $00000008;
  MDPROPVAL_MSF_PERIODSTODATE = $00000010;
  MDPROPVAL_MSF_LASTPERIODS = $00000020;
  MDPROPVAL_MSF_YTD = $00000040;
  MDPROPVAL_MSF_QTD = $00000080;
  MDPROPVAL_MSF_MTD = $00000100;
  MDPROPVAL_MSF_WTD = $00000200;
  MDPROPVAL_MSF_DRILLDOWNMEMBBER = $00000400;
  MDPROPVAL_MSF_DRILLDOWNLEVEL = $00000800;
  MDPROPVAL_MSF_DRILLDOWNMEMBERTOP = $00001000;
  MDPROPVAL_MSF_DRILLDOWNMEMBERBOTTOM = $00002000;
  MDPROPVAL_MSF_DRILLDOWNLEVELTOP = $00004000;
  MDPROPVAL_MSF_DRILLDOWNLEVELBOTTOM = $00008000;
  MDPROPVAL_MSF_DRILLUPMEMBER = $00010000;
  MDPROPVAL_MSF_DRILLUPLEVEL = $00020000;
  MDPROPVAL_MSF_TOGGLEDRILLSTATE = $00040000;
  MDPROPVAL_MD_SELF = $00000001;
  MDPROPVAL_MD_BEFORE = $00000002;
  MDPROPVAL_MD_AFTER = $00000004;
  MDPROPVAL_MSC_LESSTHAN = $00000001;
  MDPROPVAL_MSC_GREATERTHAN = $00000002;
  MDPROPVAL_MSC_LESSTHANEQUAL = $00000004;
  MDPROPVAL_MSC_GREATERTHANEQUAL = $00000008;
  MDPROPVAL_MC_SINGLECASE = $00000001;
  MDPROPVAL_MC_SEARCHEDCASE = $00000002;
  MDPROPVAL_MOQ_OUTERREFERENCE = $00000001;
  MDPROPVAL_MOQ_DATASOURCE_CUBE = $00000001;
  MDPROPVAL_MOQ_CATALOG_CUBE = $00000002;
  MDPROPVAL_MOQ_SCHEMA_CUBE = $00000004;
  MDPROPVAL_MOQ_CUBE_DIM = $00000008;
  MDPROPVAL_MOQ_DIM_HIER = $00000010;
  MDPROPVAL_MOQ_DIMHIER_LEVEL = $00000020;
  MDPROPVAL_MOQ_LEVEL_MEMBER = $00000040;
  MDPROPVAL_MOQ_MEMBER_MEMBER = $00000080;
  MDPROPVAL_FS_FULL_SUPPORT = $00000001;
  MDPROPVAL_FS_GENERATED_COLUMN = $00000002;
  MDPROPVAL_FS_GENERATED_DIMENSION = $00000003;
  MDPROPVAL_FS_NO_SUPPORT = $00000004;
  MDPROPVAL_NL_NAMEDLEVELS = $00000001;
  MDPROPVAL_NL_NUMBEREDLEVELS = $00000002;
  MDPROPVAL_MJC_SINGLECUBE = $00000001;
  MDPROPVAL_MJC_MULTICUBES = $00000002;
  MDPROPVAL_MJC_IMPLICITCUBE = $00000004;
  MDPROPVAL_RR_NORANGEROWSET = $00000001;
  MDPROPVAL_RR_READONLY = $00000002;
  MDPROPVAL_RR_UPDATE = $00000004;
  MDPROPVAL_MS_MULTIPLETUPLES = $00000001;
  MDPROPVAL_MS_SINGLETUPLE = $00000002;
  DBPROPVAL_AO_SEQUENTIAL = $00000000;
  DBPROPVAL_AO_SEQUENTIALSTORAGEOBJECTS = $00000001;
  DBPROPVAL_AO_RANDOM = $00000002;
  DBPROPVAL_BD_ROWSET = $00000000;
  DBPROPVAL_BD_INTRANSACTION = $00000001;
  DBPROPVAL_BD_XTRANSACTION = $00000002;
  DBPROPVAL_BD_REORGANIZATION = $00000003;
  BMK_DURABILITY_ROWSET = DBPROPVAL_BD_ROWSET;
  BMK_DURABILITY_INTRANSACTION = DBPROPVAL_BD_INTRANSACTION;
  BMK_DURABILITY_XTRANSACTION = DBPROPVAL_BD_XTRANSACTION;
  BMK_DURABILITY_REORGANIZATION = DBPROPVAL_BD_REORGANIZATION;
  DBPROPVAL_BO_NOLOG = $00000000;
  DBPROPVAL_BO_NOINDEXUPDATE = $00000001;
  DBPROPVAL_BO_REFINTEGRITY = $00000002;
  DBPROPVAL_STGM_READ = OF_READ;
  DBPROPVAL_STGM_WRITE = OF_WRITE;
  DBPROPVAL_STGM_READWRITE = OF_READWRITE;
  DBPROPVAL_STGM_SHARE_DENY_NONE = OF_SHARE_DENY_NONE;
  DBPROPVAL_STGM_SHARE_DENY_READ = OF_SHARE_DENY_READ;
  DBPROPVAL_STGM_SHARE_DENY_WRITE = OF_SHARE_DENY_WRITE;
  DBPROPVAL_STGM_SHARE_EXCLUSIVE = OF_SHARE_EXCLUSIVE;
  DBPROPVAL_STGM_DIRECT = $00010000;
  DBPROPVAL_STGM_TRANSACTED = $00020000;
  DBPROPVAL_STGM_CREATE = OF_CREATE;
  DBPROPVAL_STGM_CONVERT = $00040000;
  DBPROPVAL_STGM_FAILIFTHERE = $00080000;
  DBPROPVAL_STGM_PRIORITY = $00100000;
  DBPROPVAL_STGM_DELETEONRELEASE = $00200000;
  DBPROPVAL_GB_COLLATE = $00000010;
  DBPROPVAL_CS_UNINITIALIZED = $00000000;
  DBPROPVAL_CS_INITIALIZED = $00000001;
  DBPROPVAL_CS_COMMUNICATIONFAILURE = $00000002;
  DBPROPVAL_RD_RESETALL = $ffffffff;
  DBPROPVAL_OS_RESOURCEPOOLING = $00000001;
  DBPROPVAL_OS_TXNENLISTMENT = $00000002;
  DBPROPVAL_OS_CLIENTCURSOR = $00000004;
  DBPROPVAL_OS_ENABLEALL = $ffffffff;
  DBPROPVAL_BI_CROSSROWSET = $00000001;
  DB_IMP_LEVEL_ANONYMOUS = $00;
  DB_IMP_LEVEL_IDENTIFY = $01;
  DB_IMP_LEVEL_IMPERSONATE = $02;
  DB_IMP_LEVEL_DELEGATE = $03;
  DBPROMPT_PROMPT = $01;
  DBPROMPT_COMPLETE = $02;
  DBPROMPT_COMPLETEREQUIRED = $03;
  DBPROMPT_NOPROMPT = $04;
  DB_PROT_LEVEL_NONE = $00;
  DB_PROT_LEVEL_CONNECT = $01;
  DB_PROT_LEVEL_CALL = $02;
  DB_PROT_LEVEL_PKT = $03;
  DB_PROT_LEVEL_PKT_INTEGRITY = $04;
  DB_PROT_LEVEL_PKT_PRIVACY = $05;
  DB_MODE_READ = $01;
  DB_MODE_WRITE = $02;
  DB_MODE_READWRITE = $03;
  DB_MODE_SHARE_DENY_READ = $04;
  DB_MODE_SHARE_DENY_WRITE = $08;
  DB_MODE_SHARE_EXCLUSIVE = $0c;
  DB_MODE_SHARE_DENY_NONE = $10;
  DBCOMPUTEMODE_COMPUTED = $01;
  DBCOMPUTEMODE_DYNAMIC = $02;
  DBCOMPUTEMODE_NOTCOMPUTED = $03;
  DBPROPVAL_DF_INITIALLY_DEFERRED = $01;
  DBPROPVAL_DF_INITIALLY_IMMEDIATE = $02;
  DBPROPVAL_DF_NOT_DEFERRABLE = $03;
  DBPARAMTYPE_INPUT = $01;
  DBPARAMTYPE_INPUTOUTPUT = $02;
  DBPARAMTYPE_OUTPUT = $03;
  DBPARAMTYPE_RETURNVALUE = $04;
  DB_PT_UNKNOWN = $01;
  DB_PT_PROCEDURE = $02;
  DB_PT_FUNCTION = $03;
  DB_REMOTE = $01;
  DB_LOCAL_SHARED = $02;
  DB_LOCAL_EXCLUSIVE = $03;
  DB_COLLATION_ASC = $01;
  DB_COLLATION_DESC = $02;
  DB_UNSEARCHABLE = $01;
  DB_LIKE_ONLY = $02;
  DB_ALL_EXCEPT_LIKE = $03;
  DB_SEARCHABLE = $04;
  MDTREEOP_CHILDREN = $01;
  MDTREEOP_SIBLINGS = $02;
  MDTREEOP_PARENT = $04;
  MDTREEOP_SELF = $08;
  MDTREEOP_DESCENDANTS = $10;
  MDTREEOP_ANCESTORS = $20;
  MD_DIMTYPE_UNKNOWN = $00;
  MD_DIMTYPE_TIME = $01;
  MD_DIMTYPE_MEASURE = $02;
  MD_DIMTYPE_OTHER = $03;
  MDLEVEL_TYPE_UNKNOWN = $0000;
  MDLEVEL_TYPE_REGULAR = $0000;
  MDLEVEL_TYPE_ALL = $0001;
  MDLEVEL_TYPE_CALCULATED = $0002;
  MDLEVEL_TYPE_TIME = $0004;
  MDLEVEL_TYPE_RESERVED1 = $0008;
  MDLEVEL_TYPE_TIME_YEARS = $0014;
  MDLEVEL_TYPE_TIME_HALF_YEAR = $0024;
  MDLEVEL_TYPE_TIME_QUARTERS = $0044;
  MDLEVEL_TYPE_TIME_MONTHS = $0084;
  MDLEVEL_TYPE_TIME_WEEKS = $0104;
  MDLEVEL_TYPE_TIME_DAYS = $0204;
  MDLEVEL_TYPE_TIME_HOURS = $0304;
  MDLEVEL_TYPE_TIME_MINUTES = $0404;
  MDLEVEL_TYPE_TIME_SECONDS = $0804;
  MDLEVEL_TYPE_TIME_UNDEFINED = $1004;
  MDMEASURE_AGGR_UNKNOWN = $00;
  MDMEASURE_AGGR_SUM = $01;
  MDMEASURE_AGGR_COUNT = $02;
  MDMEASURE_AGGR_MIN = $03;
  MDMEASURE_AGGR_MAX = $04;
  MDMEASURE_AGGR_AVG = $05;
  MDMEASURE_AGGR_VAR = $06;
  MDMEASURE_AGGR_STD = $07;
  MDMEASURE_AGGR_CALCULATED = $7f;
  MDPROP_MEMBER = $01;
  MDPROP_CELL = $02;
  MDMEMBER_TYPE_UNKNOWN = $00;
  MDMEMBER_TYPE_REGULAR = $01;
  MDMEMBER_TYPE_ALL = $02;
  MDMEMBER_TYPE_MEASURE = $03;
  MDMEMBER_TYPE_FORMULA = $04;
  MDMEMBER_TYPE_RESERVE1 = $05;
  MDMEMBER_TYPE_RESERVE2 = $06;
  MDMEMBER_TYPE_RESERVE3 = $07;
  MDMEMBER_TYPE_RESERVE4 = $08;
  MDDISPINFO_DRILLED_DOWN = $00010000;
  MDDISPINFO_PARENT_SAME_AS_PREV = $00020000;
  DB_COUNTUNAVAILABLE = -1;
  MDFF_BOLD = $01;
  MDFF_ITALIC = $02;
  MDFF_UNDERLINE = $04;
  MDFF_STRIKEOUT = $08;
  MDAXIS_COLUMNS = $00000000;
  MDAXIS_ROWS = $00000001;
  MDAXIS_PAGES = $00000002;
  MDAXIS_SECTIONS = $00000003;
  MDAXIS_CHAPTERS = $00000004;
  MDAXIS_SLICERS = $ffffffff;
  GENERATE_METHOD_EXACT = 0;
  GENERATE_METHOD_PREFIX = 1;
  GENERATE_METHOD_INFLECT = 2;
  PROPID_QUERY_RANKVECTOR = $2;
  PROPID_QUERY_RANK = $3;
  PROPID_QUERY_HITCOUNT = $4;
  PROPID_QUERY_ALL = $6;
  PROPID_STG_CONTENTS = $13;
  VECTOR_RANK_MIN = 0;
  VECTOR_RANK_MAX = 1;
  VECTOR_RANK_INNER = 2;
  VECTOR_RANK_DICE = 3;
  VECTOR_RANK_JACCARD = 4;
  DBSETFUNC_NONE = $0;
  DBSETFUNC_ALL = $1;
  DBSETFUNC_DISTINCT = $2;
  PROXIMITY_UNIT_WORD = 0;
  PROXIMITY_UNIT_SENTENCE = 1;
  PROXIMITY_UNIT_PARAGRAPH = 2;
  PROXIMITY_UNIT_CHAPTER = 3;
  CRESTRICTIONS_DBSCHEMA_ASSERTIONS = 3;
  CRESTRICTIONS_DBSCHEMA_CATALOGS = 1;
  CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS = 3;
  CRESTRICTIONS_DBSCHEMA_COLLATIONS = 3;
  CRESTRICTIONS_DBSCHEMA_COLUMNS = 4;
  CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS = 3;
  CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE = 4;
  CRESTRICTIONS_DBSCHEMA_CONSTRAINT_TABLE_USAGE = 3;
  CRESTRICTIONS_DBSCHEMA_KEY_COLUMN_USAGE = 7;
  CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS = 3;
  CRESTRICTIONS_DBSCHEMA_TABLE_CONSTRAINTS = 7;
  CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE = 4;
  CRESTRICTIONS_DBSCHEMA_INDEXES = 5;
  CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS = 1;
  CRESTRICTIONS_DBSCHEMA_OBJECTS = 1;
  CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES = 6;
  CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES = 5;
  CRESTRICTIONS_DBSCHEMA_USAGE_PRIVILEGES = 6;
  CRESTRICTIONS_DBSCHEMA_PROCEDURES = 4;
  CRESTRICTIONS_DBSCHEMA_SCHEMATA = 3;
  CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES = 0;
  CRESTRICTIONS_DBSCHEMA_STATISTICS = 3;
  CRESTRICTIONS_DBSCHEMA_TABLES = 4;
  CRESTRICTIONS_DBSCHEMA_TRANSLATIONS = 3;
  CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES = 2;
  CRESTRICTIONS_DBSCHEMA_VIEWS = 3;
  CRESTRICTIONS_DBSCHEMA_VIEW_COLUMN_USAGE = 3;
  CRESTRICTIONS_DBSCHEMA_VIEW_TABLE_USAGE = 3;
  CRESTRICTIONS_DBSCHEMA_PROCEDURE_PARAMETERS = 4;
  CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS = 6;
  CRESTRICTIONS_DBSCHEMA_PRIMARY_KEYS = 3;
  CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS = 4;
  CRESTRICTIONS_DBSCHEMA_TABLES_INFO = 4;
  CRESTRICTIONS_MDSCHEMA_CUBES = 3;
  CRESTRICTIONS_MDSCHEMA_DIMENSIONS = 5;
  CRESTRICTIONS_MDSCHEMA_HIERARCHIES = 6;
  CRESTRICTIONS_MDSCHEMA_LEVELS = 7;
  CRESTRICTIONS_MDSCHEMA_MEASURES = 5;
  CRESTRICTIONS_MDSCHEMA_PROPERTIES = 9;
  CRESTRICTIONS_MDSCHEMA_MEMBERS = 12;

// *********************************************************************//
// Declaration of Enumerations                                          //
// *********************************************************************//

// TX_MISC_CONSTANTS constants

type
  TOldOleEnum = Integer;
  TOleEnum = LongWord;
  TX_MISC_CONSTANTS = TOleEnum;
const
  MAX_TRAN_DESC = $00000028;

// ISOLATIONLEVEL constants
type
  ISOLATIONLEVEL = TOleEnum;
const
  ISOLATIONLEVEL_UNSPECIFIED = $FFFFFFFF;
  ISOLATIONLEVEL_CHAOS = $00000010;
  ISOLATIONLEVEL_READUNCOMMITTED = $00000100;
  ISOLATIONLEVEL_BROWSE = $00000100;
  ISOLATIONLEVEL_CURSORSTABILITY = $00001000;
  ISOLATIONLEVEL_READCOMMITTED = $00001000;
  ISOLATIONLEVEL_REPEATABLEREAD = $00010000;
  ISOLATIONLEVEL_SERIALIZABLE = $00100000;
  ISOLATIONLEVEL_ISOLATED = $00100000;

// ISOFLAG constants
type
  ISOFLAG = TOleEnum;
const
  ISOFLAG_RETAIN_COMMIT_DC = $00000001;
  ISOFLAG_RETAIN_COMMIT = $00000002;
  ISOFLAG_RETAIN_COMMIT_NO = $00000003;
  ISOFLAG_RETAIN_ABORT_DC = $00000004;
  ISOFLAG_RETAIN_ABORT = $00000008;
  ISOFLAG_RETAIN_ABORT_NO = $0000000C;
  ISOFLAG_RETAIN_DONTCARE = $00000005;
  ISOFLAG_RETAIN_BOTH = $0000000A;
  ISOFLAG_RETAIN_NONE = $0000000F;
  ISOFLAG_OPTIMISTIC = $00000010;
  ISOFLAG_READONLY = $00000020;

// XACTTC constants
type
  XACTTC = TOleEnum;
const
  XACTTC_SYNC_PHASEONE = $00000001;
  XACTTC_SYNC_PHASETWO = $00000002;
  XACTTC_SYNC = $00000002;
  XACTTC_ASYNC_PHASEONE = $00000004;
  XACTTC_ASYNC = $00000004;

// XACTRM constants
type
  XACTRM = TOleEnum;
const
  XACTRM_OPTIMISTICLASTWINS = $00000001;
  XACTRM_NOREADONLYPREPARES = $00000002;

// XACTCONST constants
type
  XACTCONST = TOleEnum;
const
  XACTCONST_TIMEOUTINFINITE = $00000000;

// XACTHEURISTIC constants
type
  XACTHEURISTIC = TOleEnum;
const
  XACTHEURISTIC_ABORT = $00000001;
  XACTHEURISTIC_COMMIT = $00000002;
  XACTHEURISTIC_DAMAGE = $00000003;
  XACTHEURISTIC_DANGER = $00000004;

// XACTSTAT constants
type
  XACTSTAT = TOleEnum;
const
  XACTSTAT_NONE = $00000000;
  XACTSTAT_OPENNORMAL = $00000001;
  XACTSTAT_OPENREFUSED = $00000002;
  XACTSTAT_PREPARING = $00000004;
  XACTSTAT_PREPARED = $00000008;
  XACTSTAT_PREPARERETAINING = $00000010;
  XACTSTAT_PREPARERETAINED = $00000020;
  XACTSTAT_COMMITTING = $00000040;
  XACTSTAT_COMMITRETAINING = $00000080;
  XACTSTAT_ABORTING = $00000100;
  XACTSTAT_ABORTED = $00000200;
  XACTSTAT_COMMITTED = $00000400;
  XACTSTAT_HEURISTIC_ABORT = $00000800;
  XACTSTAT_HEURISTIC_COMMIT = $00001000;
  XACTSTAT_HEURISTIC_DAMAGE = $00002000;
  XACTSTAT_HEURISTIC_DANGER = $00004000;
  XACTSTAT_FORCED_ABORT = $00008000;
  XACTSTAT_FORCED_COMMIT = $00010000;
  XACTSTAT_INDOUBT = $00020000;
  XACTSTAT_CLOSED = $00040000;
  XACTSTAT_OPEN = $00000003;
  XACTSTAT_NOTPREPARED = $0007FFC3;
  XACTSTAT_ALL = $0007FFFF;

// XACT_E constants
type
  XACT_E = TOleEnum;
const
  XACT_E_FIRST = $8004D000;
  XACT_E_LAST = $8004D01E;
  XACT_S_FIRST = $0004D000;
  XACT_S_LAST = $0004D009;
  XACT_E_ALREADYOTHERSINGLEPHASE = $8004D000;
  XACT_E_CANTRETAIN = $8004D001;
  XACT_E_COMMITFAILED = $8004D002;
  XACT_E_COMMITPREVENTED = $8004D003;
  XACT_E_HEURISTICABORT = $8004D004;
  XACT_E_HEURISTICCOMMIT = $8004D005;
  XACT_E_HEURISTICDAMAGE = $8004D006;
  XACT_E_HEURISTICDANGER = $8004D007;
  XACT_E_ISOLATIONLEVEL = $8004D008;
  XACT_E_NOASYNC = $8004D009;
  XACT_E_NOENLIST = $8004D00A;
  XACT_E_NOISORETAIN = $8004D00B;
  XACT_E_NORESOURCE = $8004D00C;
  XACT_E_NOTCURRENT = $8004D00D;
  XACT_E_NOTRANSACTION = $8004D00E;
  XACT_E_NOTSUPPORTED = $8004D00F;
  XACT_E_UNKNOWNRMGRID = $8004D010;
  XACT_E_WRONGSTATE = $8004D011;
  XACT_E_WRONGUOW = $8004D012;
  XACT_E_XTIONEXISTS = $8004D013;
  XACT_E_NOIMPORTOBJECT = $8004D014;
  XACT_E_INVALIDCOOKIE = $8004D015;
  XACT_E_INDOUBT = $8004D016;
  XACT_E_NOTIMEOUT = $8004D017;
  XACT_E_ALREADYINPROGRESS = $8004D018;
  XACT_E_ABORTED = $8004D019;
  XACT_E_LOGFULL = $8004D01A;
  XACT_E_TMNOTAVAILABLE = $8004D01B;
  XACT_E_CONNECTION_DOWN = $8004D01C;
  XACT_E_CONNECTION_DENIED = $8004D01D;
  XACT_E_REENLISTTIMEOUT = $8004D01E;
  XACT_S_ASYNC = $0004D000;
  XACT_S_DEFECT = $0004D001;
  XACT_S_READONLY = $0004D002;
  XACT_S_SOMENORETAIN = $0004D003;
  XACT_S_OKINFORM = $0004D004;
  XACT_S_MADECHANGESCONTENT = $0004D005;
  XACT_S_MADECHANGESINFORM = $0004D006;
  XACT_S_ALLNORETAIN = $0004D007;
  XACT_S_ABORTING = $0004D008;
  XACT_S_SINGLEPHASE = $0004D009;

// DBKINDENUM constants
type
  DBKINDENUM = TOleEnum;
const
  DBKIND_GUID_NAME = $00000000;
  DBKIND_GUID_PROPID = $00000001;
  DBKIND_NAME = $00000002;
  DBKIND_PGUID_NAME = $00000003;
  DBKIND_PGUID_PROPID = $00000004;
  DBKIND_PROPID = $00000005;
  DBKIND_GUID = $00000006;

// DBTYPEENUM constants
type
  DBTYPEENUM = TOleEnum;
const
  DBTYPE_EMPTY = $00000000;
  DBTYPE_NULL = $00000001;
  DBTYPE_I2 = $00000002;
  DBTYPE_I4 = $00000003;
  DBTYPE_R4 = $00000004;
  DBTYPE_R8 = $00000005;
  DBTYPE_CY = $00000006;
  DBTYPE_DATE = $00000007;
  DBTYPE_BSTR = $00000008;
  DBTYPE_IDISPATCH = $00000009;
  DBTYPE_ERROR = $0000000A;
  DBTYPE_BOOL = $0000000B;
  DBTYPE_VARIANT = $0000000C;
  DBTYPE_IUNKNOWN = $0000000D;
  DBTYPE_DECIMAL = $0000000E;
  DBTYPE_UI1 = $00000011;
  DBTYPE_ARRAY = $00002000;
  DBTYPE_BYREF = $00004000;
  DBTYPE_I1 = $00000010;
  DBTYPE_UI2 = $00000012;
  DBTYPE_UI4 = $00000013;
  DBTYPE_I8 = $00000014;
  DBTYPE_UI8 = $00000015;
  DBTYPE_GUID = $00000048;
  DBTYPE_VECTOR = $00001000;
  DBTYPE_RESERVED = $00008000;
  DBTYPE_BYTES = $00000080;
  DBTYPE_STR = $00000081;
  DBTYPE_WSTR = $00000082;
  DBTYPE_NUMERIC = $00000083;
  DBTYPE_UDT = $00000084;
  DBTYPE_DBDATE = $00000085;
  DBTYPE_DBTIME = $00000086;
  DBTYPE_DBTIMESTAMP = $00000087;

// DBTYPEENUM15 constants
type
  DBTYPEENUM15 = TOleEnum;
const
  DBTYPE_HCHAPTER = $00000088;

// DBTYPEENUM20 constants
type
  DBTYPEENUM20 = TOleEnum;
const
  DBTYPE_FILETIME = $00000040;
  DBTYPE_DBFILETIME = $00000089;
  DBTYPE_PROPVARIANT = $0000008A;
  DBTYPE_VARNUMERIC = $0000008B;

// DBPARTENUM constants
type
  DBPARTENUM = TOleEnum;
const
  DBPART_INVALID = $00000000;
  DBPART_VALUE = $00000001;
  DBPART_LENGTH = $00000002;
  DBPART_STATUS = $00000004;

// DBPARAMIOENUM constants
type
  DBPARAMIOENUM = TOleEnum;
const
  DBPARAMIO_NOTPARAM = $00000000;
  DBPARAMIO_INPUT = $00000001;
  DBPARAMIO_OUTPUT = $00000002;

// DBBINDFLAGENUM constants
type
  DBBINDFLAGENUM = TOleEnum;
const
  DBBINDFLAG_HTML = $00000001;

// DBMEMOWNERENUM constants
type
  DBMEMOWNERENUM = TOleEnum;
const
  DBMEMOWNER_CLIENTOWNED = $00000000;
  DBMEMOWNER_PROVIDEROWNED = $00000001;

// DBSTATUSENUM constants
type
  DBSTATUSENUM = TOleEnum;
const
  DBSTATUS_S_OK = $00000000;
  DBSTATUS_E_BADACCESSOR = $00000001;
  DBSTATUS_E_CANTCONVERTVALUE = $00000002;
  DBSTATUS_S_ISNULL = $00000003;
  DBSTATUS_S_TRUNCATED = $00000004;
  DBSTATUS_E_SIGNMISMATCH = $00000005;
  DBSTATUS_E_DATAOVERFLOW = $00000006;
  DBSTATUS_E_CANTCREATE = $00000007;
  DBSTATUS_E_UNAVAILABLE = $00000008;
  DBSTATUS_E_PERMISSIONDENIED = $00000009;
  DBSTATUS_E_INTEGRITYVIOLATION = $0000000A;
  DBSTATUS_E_SCHEMAVIOLATION = $0000000B;
  DBSTATUS_E_BADSTATUS = $0000000C;
  DBSTATUS_S_DEFAULT = $0000000D;

// DBSTATUSENUM20 constants
type
  DBSTATUSENUM20 = TOleEnum;
const
  MDSTATUS_S_CELLEMPTY = $0000000E;
  DBSTATUS_S_IGNORE = $0000000F;

// DBROWSTATUSENUM constants
type
  DBROWSTATUSENUM = TOleEnum;
const
  DBROWSTATUS_S_OK = $00000000;
  DBROWSTATUS_S_MULTIPLECHANGES = $00000002;
  DBROWSTATUS_S_PENDINGCHANGES = $00000003;
  DBROWSTATUS_E_CANCELED = $00000004;
  DBROWSTATUS_E_CANTRELEASE = $00000006;
  DBROWSTATUS_E_CONCURRENCYVIOLATION = $00000007;
  DBROWSTATUS_E_DELETED = $00000008;
  DBROWSTATUS_E_PENDINGINSERT = $00000009;
  DBROWSTATUS_E_NEWLYINSERTED = $0000000A;
  DBROWSTATUS_E_INTEGRITYVIOLATION = $0000000B;
  DBROWSTATUS_E_INVALID = $0000000C;
  DBROWSTATUS_E_MAXPENDCHANGESEXCEEDED = $0000000D;
  DBROWSTATUS_E_OBJECTOPEN = $0000000E;
  DBROWSTATUS_E_OUTOFMEMORY = $0000000F;
  DBROWSTATUS_E_PERMISSIONDENIED = $00000010;
  DBROWSTATUS_E_LIMITREACHED = $00000011;
  DBROWSTATUS_E_SCHEMAVIOLATION = $00000012;
  DBROWSTATUS_E_FAIL = $00000013;

// DBROWSTATUSENUM20 constants
type
  DBROWSTATUSENUM20 = TOleEnum;
const
  DBROWSTATUS_S_NOCHANGE = $00000014;

// DBCOLUMNFLAGSENUM constants
type
  DBCOLUMNFLAGSENUM = TOleEnum;
const
  DBCOLUMNFLAGS_ISBOOKMARK = $00000001;
  DBCOLUMNFLAGS_MAYDEFER = $00000002;
  DBCOLUMNFLAGS_WRITE = $00000004;
  DBCOLUMNFLAGS_WRITEUNKNOWN = $00000008;
  DBCOLUMNFLAGS_ISFIXEDLENGTH = $00000010;
  DBCOLUMNFLAGS_ISNULLABLE = $00000020;
  DBCOLUMNFLAGS_MAYBENULL = $00000040;
  DBCOLUMNFLAGS_ISLONG = $00000080;
  DBCOLUMNFLAGS_ISROWID = $00000100;
  DBCOLUMNFLAGS_ISROWVER = $00000200;
  DBCOLUMNFLAGS_CACHEDEFERRED = $00001000;

// DBCOLUMNFLAGSENUM20 constants
type
  DBCOLUMNFLAGSENUM20 = TOleEnum;
const
  DBCOLUMNFLAGS_SCALEISNEGATIVE = $00004000;
  DBCOLUMNFLAGS_KEYCOLUMN = $00008000;

// DBCOLUMNFLAGS15ENUM constants
type
  DBCOLUMNFLAGS15ENUM = TOleEnum;
const
  DBCOLUMNFLAGS_ISCHAPTER = $00002000;

// DBBOOKMARK constants
type
  DBBOOKMARK = TOleEnum;
const
  DBBMK_INVALID = $00000000;
  DBBMK_FIRST = $00000001;
  DBBMK_LAST = $00000002;

// DBPROPENUM constants
type
  DBPROPENUM = TOleEnum;
const
  DBPROP_ABORTPRESERVE = $00000002;
  DBPROP_ACTIVESESSIONS = $00000003;
  DBPROP_APPENDONLY = $000000BB;
  DBPROP_ASYNCTXNABORT = $000000A8;
  DBPROP_ASYNCTXNCOMMIT = $00000004;
  DBPROP_AUTH_CACHE_AUTHINFO = $00000005;
  DBPROP_AUTH_ENCRYPT_PASSWORD = $00000006;
  DBPROP_AUTH_INTEGRATED = $00000007;
  DBPROP_AUTH_MASK_PASSWORD = $00000008;
  DBPROP_AUTH_PASSWORD = $00000009;
  DBPROP_AUTH_PERSIST_ENCRYPTED = $0000000A;
  DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO = $0000000B;
  DBPROP_AUTH_USERID = $0000000C;
  DBPROP_BLOCKINGSTORAGEOBJECTS = $0000000D;
  DBPROP_BOOKMARKS = $0000000E;
  DBPROP_BOOKMARKSKIPPED = $0000000F;
  DBPROP_BOOKMARKTYPE = $00000010;
  DBPROP_BYREFACCESSORS = $00000078;
  DBPROP_CACHEDEFERRED = $00000011;
  DBPROP_CANFETCHBACKWARDS = $00000012;
  DBPROP_CANHOLDROWS = $00000013;
  DBPROP_CANSCROLLBACKWARDS = $00000015;
  DBPROP_CATALOGLOCATION = $00000016;
  DBPROP_CATALOGTERM = $00000017;
  DBPROP_CATALOGUSAGE = $00000018;
  DBPROP_CHANGEINSERTEDROWS = $000000BC;
  DBPROP_COL_AUTOINCREMENT = $0000001A;
  DBPROP_COL_DEFAULT = $0000001B;
  DBPROP_COL_DESCRIPTION = $0000001C;
  DBPROP_COL_FIXEDLENGTH = $000000A7;
  DBPROP_COL_NULLABLE = $0000001D;
  DBPROP_COL_PRIMARYKEY = $0000001E;
  DBPROP_COL_UNIQUE = $0000001F;
  DBPROP_COLUMNDEFINITION = $00000020;
  DBPROP_COLUMNRESTRICT = $00000021;
  DBPROP_COMMANDTIMEOUT = $00000022;
  DBPROP_COMMITPRESERVE = $00000023;
  DBPROP_CONCATNULLBEHAVIOR = $00000024;
  DBPROP_CURRENTCATALOG = $00000025;
  DBPROP_DATASOURCENAME = $00000026;
  DBPROP_DATASOURCEREADONLY = $00000027;
  DBPROP_DBMSNAME = $00000028;
  DBPROP_DBMSVER = $00000029;
  DBPROP_DEFERRED = $0000002A;
  DBPROP_DELAYSTORAGEOBJECTS = $0000002B;
  DBPROP_DSOTHREADMODEL = $000000A9;
  DBPROP_GROUPBY = $0000002C;
  DBPROP_HETEROGENEOUSTABLES = $0000002D;
  DBPROP_IAccessor = $00000079;
  DBPROP_IColumnsInfo = $0000007A;
  DBPROP_IColumnsRowset = $0000007B;
  DBPROP_IConnectionPointContainer = $0000007C;
  DBPROP_IConvertType = $000000C2;
  DBPROP_IRowset = $0000007E;
  DBPROP_IRowsetChange = $0000007F;
  DBPROP_IRowsetIdentity = $00000080;
  DBPROP_IRowsetIndex = $0000009F;
  DBPROP_IRowsetInfo = $00000081;
  DBPROP_IRowsetLocate = $00000082;
  DBPROP_IRowsetResynch = $00000084;
  DBPROP_IRowsetScroll = $00000085;
  DBPROP_IRowsetUpdate = $00000086;
  DBPROP_ISupportErrorInfo = $00000087;
  DBPROP_ILockBytes = $00000088;
  DBPROP_ISequentialStream = $00000089;
  DBPROP_IStorage = $0000008A;
  DBPROP_IStream = $0000008B;
  DBPROP_IDENTIFIERCASE = $0000002E;
  DBPROP_IMMOBILEROWS = $0000002F;
  DBPROP_INDEX_AUTOUPDATE = $00000030;
  DBPROP_INDEX_CLUSTERED = $00000031;
  DBPROP_INDEX_FILLFACTOR = $00000032;
  DBPROP_INDEX_INITIALSIZE = $00000033;
  DBPROP_INDEX_NULLCOLLATION = $00000034;
  DBPROP_INDEX_NULLS = $00000035;
  DBPROP_INDEX_PRIMARYKEY = $00000036;
  DBPROP_INDEX_SORTBOOKMARKS = $00000037;
  DBPROP_INDEX_TEMPINDEX = $000000A3;
  DBPROP_INDEX_TYPE = $00000038;
  DBPROP_INDEX_UNIQUE = $00000039;
  DBPROP_INIT_DATASOURCE = $0000003B;
  DBPROP_INIT_HWND = $0000003C;
  DBPROP_INIT_IMPERSONATION_LEVEL = $0000003D;
  DBPROP_INIT_LCID = $000000BA;
  DBPROP_INIT_LOCATION = $0000003E;
  DBPROP_INIT_MODE = $0000003F;
  DBPROP_INIT_PROMPT = $00000040;
  DBPROP_INIT_PROTECTION_LEVEL = $00000041;
  DBPROP_INIT_PROVIDERSTRING = $000000A0;
  DBPROP_INIT_TIMEOUT = $00000042;
  DBPROP_LITERALBOOKMARKS = $00000043;
  DBPROP_LITERALIDENTITY = $00000044;
  DBPROP_MARSHALLABLE = $000000C5;
  DBPROP_MAXINDEXSIZE = $00000046;
  DBPROP_MAXOPENROWS = $00000047;
  DBPROP_MAXPENDINGROWS = $00000048;
  DBPROP_MAXROWS = $00000049;
  DBPROP_MAXROWSIZE = $0000004A;
  DBPROP_MAXROWSIZEINCLUDESBLOB = $0000004B;
  DBPROP_MAXTABLESINSELECT = $0000004C;
  DBPROP_MAYWRITECOLUMN = $0000004D;
  DBPROP_MEMORYUSAGE = $0000004E;
  DBPROP_MULTIPLEPARAMSETS = $000000BF;
  DBPROP_MULTIPLERESULTS = $000000C4;
  DBPROP_MULTIPLESTORAGEOBJECTS = $00000050;
  DBPROP_MULTITABLEUPDATE = $00000051;
  DBPROP_NOTIFICATIONGRANULARITY = $000000C6;
  DBPROP_NOTIFICATIONPHASES = $00000052;
  DBPROP_NOTIFYCOLUMNSET = $000000AB;
  DBPROP_NOTIFYROWDELETE = $000000AD;
  DBPROP_NOTIFYROWFIRSTCHANGE = $000000AE;
  DBPROP_NOTIFYROWINSERT = $000000AF;
  DBPROP_NOTIFYROWRESYNCH = $000000B1;
  DBPROP_NOTIFYROWSETCHANGED = $000000D3;
  DBPROP_NOTIFYROWSETRELEASE = $000000B2;
  DBPROP_NOTIFYROWSETFETCHPOSITIONCHANGE = $000000B3;
  DBPROP_NOTIFYROWUNDOCHANGE = $000000B4;
  DBPROP_NOTIFYROWUNDODELETE = $000000B5;
  DBPROP_NOTIFYROWUNDOINSERT = $000000B6;
  DBPROP_NOTIFYROWUPDATE = $000000B7;
  DBPROP_NULLCOLLATION = $00000053;
  DBPROP_OLEOBJECTS = $00000054;
  DBPROP_ORDERBYCOLUMNSINSELECT = $00000055;
  DBPROP_ORDEREDBOOKMARKS = $00000056;
  DBPROP_OTHERINSERT = $00000057;
  DBPROP_OTHERUPDATEDELETE = $00000058;
  DBPROP_OUTPUTPARAMETERAVAILABILITY = $000000B8;
  DBPROP_OWNINSERT = $00000059;
  DBPROP_OWNUPDATEDELETE = $0000005A;
  DBPROP_PERSISTENTIDTYPE = $000000B9;
  DBPROP_PREPAREABORTBEHAVIOR = $0000005B;
  DBPROP_PREPARECOMMITBEHAVIOR = $0000005C;
  DBPROP_PROCEDURETERM = $0000005D;
  DBPROP_PROVIDERNAME = $00000060;
  DBPROP_PROVIDERFILENAME = DBPROP_PROVIDERNAME;
  DBPROP_PROVIDEROLEDBVER = $00000061;
  DBPROP_PROVIDERVER = $00000062;
  DBPROP_QUICKRESTART = $00000063;
  DBPROP_QUOTEDIDENTIFIERCASE = $00000064;
  DBPROP_REENTRANTEVENTS = $00000065;
  DBPROP_REMOVEDELETED = $00000066;
  DBPROP_REPORTMULTIPLECHANGES = $00000067;
  DBPROP_RETURNPENDINGINSERTS = $000000BD;
  DBPROP_ROWRESTRICT = $00000068;
  DBPROP_ROWSETCONVERSIONSONCOMMAND = $000000C0;
  DBPROP_ROWTHREADMODEL = $00000069;
  DBPROP_SCHEMATERM = $0000006A;
  DBPROP_SCHEMAUSAGE = $0000006B;
  DBPROP_SERVERCURSOR = $0000006C;
  DBPROP_SESS_AUTOCOMMITISOLEVELS = $000000BE;
  DBPROP_SQLSUPPORT = $0000006D;
  DBPROP_STRONGIDENTITY = $00000077;
  DBPROP_STRUCTUREDSTORAGE = $0000006F;
  DBPROP_SUBQUERIES = $00000070;
  DBPROP_SUPPORTEDTXNDDL = $000000A1;
  DBPROP_SUPPORTEDTXNISOLEVELS = $00000071;
  DBPROP_SUPPORTEDTXNISORETAIN = $00000072;
  DBPROP_TABLETERM = $00000073;
  DBPROP_TBL_TEMPTABLE = $0000008C;
  DBPROP_TRANSACTEDOBJECT = $00000074;
  DBPROP_UPDATABILITY = $00000075;
  DBPROP_USERNAME = $00000076;

// DBPROPENUM15 constants
type
  DBPROPENUM15 = TOleEnum;
const
  DBPROP_FILTEROPS = $000000D0;
  DBPROP_FILTERCOMPAREOPS = $000000D1;
  DBPROP_FINDCOMPAREOPS = $000000D2;
  DBPROP_IChapteredRowset = $000000CA;
  DBPROP_IDBAsynchStatus = $000000CB;
  DBPROP_IRowsetFind = $000000CC;
  DBPROP_IRowsetView = $000000D4;
  DBPROP_IViewChapter = $000000D5;
  DBPROP_IViewFilter = $000000D6;
  DBPROP_IViewRowset = $000000D7;
  DBPROP_IViewSort = $000000D8;
  DBPROP_INIT_ASYNCH = $000000C8;
  DBPROP_MAXOPENCHAPTERS = $000000C7;
  DBPROP_MAXORSINFILTER = $000000CD;
  DBPROP_MAXSORTCOLUMNS = $000000CE;
  DBPROP_ROWSET_ASYNCH = $000000C9;
  DBPROP_SORTONINDEX = $000000CF;

// DBPROPENUM20 constants
type
  DBPROPENUM20 = TOleEnum;
const
  DBPROP_IMultipleResults = $000000D9;
  DBPROP_DATASOURCE_TYPE = $000000FB;
  MDPROP_AXES = $000000FC;
  MDPROP_FLATTENING_SUPPORT = $000000FD;
  MDPROP_MDX_JOINCUBES = $000000FE;
  MDPROP_NAMED_LEVELS = $000000FF;
  MDPROP_RANGEROWSET = $00000100;
  MDPROP_MDX_SLICER = $000000DA;
  MDPROP_MDX_CUBEQUALIFICATION = $000000DB;
  MDPROP_MDX_OUTERREFERENCE = $000000DC;
  MDPROP_MDX_QUERYBYPROPERTY = $000000DD;
  MDPROP_MDX_CASESUPPORT = $000000DE;
  MDPROP_MDX_STRING_COMPOP = $000000E0;
  MDPROP_MDX_DESCFLAGS = $000000E1;
  MDPROP_MDX_SET_FUNCTIONS = $000000E2;
  MDPROP_MDX_MEMBER_FUNCTIONS = $000000E3;
  MDPROP_MDX_NUMERIC_FUNCTIONS = $000000E4;
  MDPROP_MDX_FORMULAS = $000000E5;
  MDPROP_MDX_AGGREGATECELL_UPDATE = $000000E6;
  DBPROP_ACCESSORDER = $000000E7;
  DBPROP_BOOKMARKINFO = $000000E8;
  DBPROP_INIT_CATALOG = $000000E9;
  DBPROP_ROW_BULKOPS = $000000EA;
  DBPROP_PROVIDERFRIENDLYNAME = $000000EB;
  DBPROP_LOCKMODE = $000000EC;
  DBPROP_MULTIPLECONNECTIONS = $000000ED;
  DBPROP_UNIQUEROWS = $000000EE;
  DBPROP_SERVERDATAONINSERT = $000000EF;
  DBPROP_STORAGEFLAGS = $000000F0;
  DBPROP_CONNECTIONSTATUS = $000000F4;
  DBPROP_ALTERCOLUMN = $000000F5;
  DBPROP_COLUMNLCID = $000000F6;
  DBPROP_RESETDATASOURCE = $000000F7;
  DBPROP_INIT_OLEDBSERVICES = $000000F8;
  DBPROP_IRowsetRefresh = $000000F9;
  DBPROP_SERVERNAME = $000000FA;
  DBPROP_IParentRowset = $00000101;
  DBPROP_HIDDENCOLUMNS = $00000102;
  DBPROP_PROVIDERMEMORY = $00000103;
  DBPROP_CLIENTCURSOR = $00000104;

// DBPROPENUM21 constants
type
  DBPROPENUM21 = TOleEnum;
const
  DBPROP_TRUSTEE_USERNAME = $000000F1;
  DBPROP_TRUSTEE_AUTHENTICATION = $000000F2;
  DBPROP_TRUSTEE_NEWAUTHENTICATION = $000000F3;

// DBPROPENUM25 constants
type
  DBPROPENUM25 = TOleEnum;
const
  DBPROP_ICommandCost = $0000008D;
  DBPROP_ICommandTree = $0000008E;
  DBPROP_ICommandValidate = $0000008F;
  DBPROP_IDBSchemaCommand = $00000090;
  DBPROP_IProvideMoniker = $0000007D;
  DBPROP_IQuery = $00000092;
  DBPROP_IReadData = $00000093;
  DBPROP_IRowsetAsynch = $00000094;
  DBPROP_IRowsetKeys = $00000097;
  DBPROP_IRowsetNewRowAfter = $00000098;
  DBPROP_IRowsetNextRowset = $00000099;
  DBPROP_IRowsetWatchAll = $0000009B;
  DBPROP_IRowsetWatchNotify = $0000009C;
  DBPROP_IRowsetWatchRegion = $0000009D;
  DBPROP_IRowsetWithParameters = $0000009E;

// DBPROPENUMDEPRECATED constants
type
  DBPROPENUMDEPRECATED = TOleEnum;
const
  DBPROP_IRowsetExactScroll = $0000009A;

// DBCOMMANDOPENUM constants
type
  DBCOMMANDOPENUM = TOleEnum;
const
  DBOP_scalar_constant = $00000000;
  DBOP_DEFAULT = $00000001;
  DBOP_NULL = $00000002;
  DBOP_bookmark_name = $00000003;
  DBOP_catalog_name = $00000004;
  DBOP_column_name = $00000005;
  DBOP_schema_name = $00000006;
  DBOP_outall_name = $00000007;
  DBOP_qualifier_name = $00000008;
  DBOP_qualified_column_name = $00000009;
  DBOP_table_name = $0000000A;
  DBOP_nested_table_name = $0000000B;
  DBOP_nested_column_name = $0000000C;
  DBOP_row = $0000000D;
  DBOP_table = $0000000E;
  DBOP_sort = $0000000F;
  DBOP_distinct = $00000010;
  DBOP_distinct_order_preserving = $00000011;
  DBOP_alias = $00000012;
  DBOP_cross_join = $00000013;
  DBOP_union_join = $00000014;
  DBOP_inner_join = $00000015;
  DBOP_left_semi_join = $00000016;
  DBOP_right_semi_join = $00000017;
  DBOP_left_anti_semi_join = $00000018;
  DBOP_right_anti_semi_join = $00000019;
  DBOP_left_outer_join = $0000001A;
  DBOP_right_outer_join = $0000001B;
  DBOP_full_outer_join = $0000001C;
  DBOP_natural_join = $0000001D;
  DBOP_natural_left_outer_join = $0000001E;
  DBOP_natural_right_outer_join = $0000001F;
  DBOP_natural_full_outer_join = $00000020;
  DBOP_set_intersection = $00000021;
  DBOP_set_union = $00000022;
  DBOP_set_left_difference = $00000023;
  DBOP_set_right_difference = $00000024;
  DBOP_set_anti_difference = $00000025;
  DBOP_bag_intersection = $00000026;
  DBOP_bag_union = $00000027;
  DBOP_bag_left_difference = $00000028;
  DBOP_bag_right_difference = $00000029;
  DBOP_bag_anti_difference = $0000002A;
  DBOP_division = $0000002B;
  DBOP_relative_sampling = $0000002C;
  DBOP_absolute_sampling = $0000002D;
  DBOP_transitive_closure = $0000002E;
  DBOP_recursive_union = $0000002F;
  DBOP_aggregate = $00000030;
  DBOP_remote_table = $00000031;
  DBOP_select = $00000032;
  DBOP_order_preserving_select = $00000033;
  DBOP_project = $00000034;
  DBOP_project_order_preserving = $00000035;
  DBOP_top = $00000036;
  DBOP_top_percent = $00000037;
  DBOP_top_plus_ties = $00000038;
  DBOP_top_percent_plus_ties = $00000039;
  DBOP_rank = $0000003A;
  DBOP_rank_ties_equally = $0000003B;
  DBOP_rank_ties_equally_and_skip = $0000003C;
  DBOP_navigate = $0000003D;
  DBOP_nesting = $0000003E;
  DBOP_unnesting = $0000003F;
  DBOP_nested_apply = $00000040;
  DBOP_cross_tab = $00000041;
  DBOP_is_NULL = $00000042;
  DBOP_is_NOT_NULL = $00000043;
  DBOP_equal = $00000044;
  DBOP_not_equal = $00000045;
  DBOP_less = $00000046;
  DBOP_less_equal = $00000047;
  DBOP_greater = $00000048;
  DBOP_greater_equal = $00000049;
  DBOP_equal_all = $0000004A;
  DBOP_not_equal_all = $0000004B;
  DBOP_less_all = $0000004C;
  DBOP_less_equal_all = $0000004D;
  DBOP_greater_all = $0000004E;
  DBOP_greater_equal_all = $0000004F;
  DBOP_equal_any = $00000050;
  DBOP_not_equal_any = $00000051;
  DBOP_less_any = $00000052;
  DBOP_less_equal_any = $00000053;
  DBOP_greater_any = $00000054;
  DBOP_greater_equal_any = $00000055;
  DBOP_anybits = $00000056;
  DBOP_allbits = $00000057;
  DBOP_anybits_any = $00000058;
  DBOP_allbits_any = $00000059;
  DBOP_anybits_all = $0000005A;
  DBOP_allbits_all = $0000005B;
  DBOP_between = $0000005C;
  DBOP_between_unordered = $0000005D;
  DBOP_match = $0000005E;
  DBOP_match_unique = $0000005F;
  DBOP_match_partial = $00000060;
  DBOP_match_partial_unique = $00000061;
  DBOP_match_full = $00000062;
  DBOP_match_full_unique = $00000063;
  DBOP_scalar_parameter = $00000064;
  DBOP_scalar_function = $00000065;
  DBOP_plus = $00000066;
  DBOP_minus = $00000067;
  DBOP_times = $00000068;
  DBOP_over = $00000069;
  DBOP_div = $0000006A;
  DBOP_modulo = $0000006B;
  DBOP_power = $0000006C;
  DBOP_like = $0000006D;
  DBOP_sounds_like = $0000006E;
  DBOP_like_any = $0000006F;
  DBOP_like_all = $00000070;
  DBOP_is_INVALID = $00000071;
  DBOP_is_TRUE = $00000072;
  DBOP_is_FALSE = $00000073;
  DBOP_and = $00000074;
  DBOP_or = $00000075;
  DBOP_xor = $00000076;
  DBOP_equivalent = $00000077;
  DBOP_not = $00000078;
  DBOP_implies = $00000079;
  DBOP_overlaps = $0000007A;
  DBOP_case_condition = $0000007B;
  DBOP_case_value = $0000007C;
  DBOP_nullif = $0000007D;
  DBOP_cast = $0000007E;
  DBOP_coalesce = $0000007F;
  DBOP_position = $00000080;
  DBOP_extract = $00000081;
  DBOP_char_length = $00000082;
  DBOP_octet_length = $00000083;
  DBOP_bit_length = $00000084;
  DBOP_substring = $00000085;
  DBOP_upper = $00000086;
  DBOP_lower = $00000087;
  DBOP_trim = $00000088;
  DBOP_translate = $00000089;
  DBOP_convert = $0000008A;
  DBOP_string_concat = $0000008B;
  DBOP_current_date = $0000008C;
  DBOP_current_time = $0000008D;
  DBOP_current_timestamp = $0000008E;
  DBOP_content_select = $0000008F;
  DBOP_content = $00000090;
  DBOP_content_freetext = $00000091;
  DBOP_content_proximity = $00000092;
  DBOP_content_vector_or = $00000093;
  DBOP_delete = $00000094;
  DBOP_update = $00000095;
  DBOP_insert = $00000096;
  DBOP_min = $00000097;
  DBOP_max = $00000098;
  DBOP_count = $00000099;
  DBOP_sum = $0000009A;
  DBOP_avg = $0000009B;
  DBOP_any_sample = $0000009C;
  DBOP_stddev = $0000009D;
  DBOP_stddev_pop = $0000009E;
  DBOP_var = $0000009F;
  DBOP_var_pop = $000000A0;
  DBOP_first = $000000A1;
  DBOP_last = $000000A2;
  DBOP_in = $000000A3;
  DBOP_exists = $000000A4;
  DBOP_unique = $000000A5;
  DBOP_subset = $000000A6;
  DBOP_proper_subset = $000000A7;
  DBOP_superset = $000000A8;
  DBOP_proper_superset = $000000A9;
  DBOP_disjoint = $000000AA;
  DBOP_pass_through = $000000AB;
  DBOP_defined_by_GUID = $000000AC;
  DBOP_text_command = $000000AD;
  DBOP_SQL_select = $000000AE;
  DBOP_prior_command_tree = $000000AF;
  DBOP_add_columns = $000000B0;
  DBOP_column_list_anchor = $000000B1;
  DBOP_column_list_element = $000000B2;
  DBOP_command_list_anchor = $000000B3;
  DBOP_command_list_element = $000000B4;
  DBOP_from_list_anchor = $000000B5;
  DBOP_from_list_element = $000000B6;
  DBOP_project_list_anchor = $000000B7;
  DBOP_project_list_element = $000000B8;
  DBOP_row_list_anchor = $000000B9;
  DBOP_row_list_element = $000000BA;
  DBOP_scalar_list_anchor = $000000BB;
  DBOP_scalar_list_element = $000000BC;
  DBOP_set_list_anchor = $000000BD;
  DBOP_set_list_element = $000000BE;
  DBOP_sort_list_anchor = $000000BF;
  DBOP_sort_list_element = $000000C0;
  DBOP_alter_character_set = $000000C1;
  DBOP_alter_collation = $000000C2;
  DBOP_alter_domain = $000000C3;
  DBOP_alter_index = $000000C4;
  DBOP_alter_procedure = $000000C5;
  DBOP_alter_schema = $000000C6;
  DBOP_alter_table = $000000C7;
  DBOP_alter_trigger = $000000C8;
  DBOP_alter_view = $000000C9;
  DBOP_coldef_list_anchor = $000000CA;
  DBOP_coldef_list_element = $000000CB;
  DBOP_create_assertion = $000000CC;
  DBOP_create_character_set = $000000CD;
  DBOP_create_collation = $000000CE;
  DBOP_create_domain = $000000CF;
  DBOP_create_index = $000000D0;
  DBOP_create_procedure = $000000D1;
  DBOP_create_schema = $000000D2;
  DBOP_create_synonym = $000000D3;
  DBOP_create_table = $000000D4;
  DBOP_create_temporary_table = $000000D5;
  DBOP_create_translation = $000000D6;
  DBOP_create_trigger = $000000D7;
  DBOP_create_view = $000000D8;
  DBOP_drop_assertion = $000000D9;
  DBOP_drop_character_set = $000000DA;
  DBOP_drop_collation = $000000DB;
  DBOP_drop_domain = $000000DC;
  DBOP_drop_index = $000000DD;
  DBOP_drop_procedure = $000000DE;
  DBOP_drop_schema = $000000DF;
  DBOP_drop_synonym = $000000E0;
  DBOP_drop_table = $000000E1;
  DBOP_drop_translation = $000000E2;
  DBOP_drop_trigger = $000000E3;
  DBOP_drop_view = $000000E4;
  DBOP_foreign_key = $000000E5;
  DBOP_grant_privileges = $000000E6;
  DBOP_index_list_anchor = $000000E7;
  DBOP_index_list_element = $000000E8;
  DBOP_primary_key = $000000E9;
  DBOP_property_list_anchor = $000000EA;
  DBOP_property_list_element = $000000EB;
  DBOP_referenced_table = $000000EC;
  DBOP_rename_object = $000000ED;
  DBOP_revoke_privileges = $000000EE;
  DBOP_schema_authorization = $000000EF;
  DBOP_unique_key = $000000F0;

// DBPARAMFLAGSENUM constants
type
  DBPARAMFLAGSENUM = TOleEnum;
const
  DBPARAMFLAGS_ISINPUT = $00000001;
  DBPARAMFLAGS_ISOUTPUT = $00000002;
  DBPARAMFLAGS_ISSIGNED = $00000010;
  DBPARAMFLAGS_ISNULLABLE = $00000040;
  DBPARAMFLAGS_ISLONG = $00000080;

// DBPARAMFLAGSENUM20 constants
type
  DBPARAMFLAGSENUM20 = TOleEnum;
const
  DBPARAMFLAGS_SCALEISNEGATIVE = $00000100;

// DBPROPFLAGSENUM constants
type
  DBPROPFLAGSENUM = TOleEnum;
const
  DBPROPFLAGS_NOTSUPPORTED = $00000000;
  DBPROPFLAGS_COLUMN = $00000001;
  DBPROPFLAGS_DATASOURCE = $00000002;
  DBPROPFLAGS_DATASOURCECREATE = $00000004;
  DBPROPFLAGS_DATASOURCEINFO = $00000008;
  DBPROPFLAGS_DBINIT = $00000010;
  DBPROPFLAGS_INDEX = $00000020;
  DBPROPFLAGS_ROWSET = $00000040;
  DBPROPFLAGS_TABLE = $00000080;
  DBPROPFLAGS_COLUMNOK = $00000100;
  DBPROPFLAGS_READ = $00000200;
  DBPROPFLAGS_WRITE = $00000400;
  DBPROPFLAGS_REQUIRED = $00000800;
  DBPROPFLAGS_SESSION = $00001000;

// DBPROPFLAGSENUM21 constants
type
  DBPROPFLAGSENUM21 = TOleEnum;
const
  DBPROPFLAGS_TRUSTEE = $00002000;

// DBPROPOPTIONSENUM constants
type
  DBPROPOPTIONSENUM = TOleEnum;
const
  DBPROPOPTIONS_REQUIRED = $00000000;
  DBPROPOPTIONS_SETIFCHEAP = $00000001;
  DBPROPOPTIONS_OPTIONAL = $00000001;

// DBPROPSTATUSENUM constants
type
  DBPROPSTATUSENUM = TOleEnum;
const
  DBPROPSTATUS_OK = $00000000;
  DBPROPSTATUS_NOTSUPPORTED = $00000001;
  DBPROPSTATUS_BADVALUE = $00000002;
  DBPROPSTATUS_BADOPTION = $00000003;
  DBPROPSTATUS_BADCOLUMN = $00000004;
  DBPROPSTATUS_NOTALLSETTABLE = $00000005;
  DBPROPSTATUS_NOTSETTABLE = $00000006;
  DBPROPSTATUS_NOTSET = $00000007;
  DBPROPSTATUS_CONFLICTING = $00000008;

// DBPROPSTATUSENUM21 constants
type
  DBPROPSTATUSENUM21 = TOleEnum;
const
  DBPROPSTATUS_NOTAVAILAVLE = $00000009;

// DBINDEX_COL_ORDERENUM constants
type
  DBINDEX_COL_ORDERENUM = TOleEnum;
const
  DBINDEX_COL_ORDER_ASC = $00000000;
  DBINDEX_COL_ORDER_DESC = $00000001;

// DBCOLUMNDESCFLAGSENUM constants
type
  DBCOLUMNDESCFLAGSENUM = TOleEnum;
const
  DBCOLUMNDESCFLAGS_TYPENAME = $00000001;
  DBCOLUMNDESCFLAGS_ITYPEINFO = $00000002;
  DBCOLUMNDESCFLAGS_PROPERTIES = $00000004;
  DBCOLUMNDESCFLAGS_CLSID = $00000008;
  DBCOLUMNDESCFLAGS_COLSIZE = $00000010;
  DBCOLUMNDESCFLAGS_DBCID = $00000020;
  DBCOLUMNDESCFLAGS_WTYPE = $00000040;
  DBCOLUMNDESCFLAGS_PRECISION = $00000080;
  DBCOLUMNDESCFLAGS_SCALE = $00000100;

// DBEVENTPHASEENUM constants
type
  DBEVENTPHASEENUM = TOleEnum;
const
  DBEVENTPHASE_OKTODO = $00000000;
  DBEVENTPHASE_ABOUTTODO = $00000001;
  DBEVENTPHASE_SYNCHAFTER = $00000002;
  DBEVENTPHASE_FAILEDTODO = $00000003;
  DBEVENTPHASE_DIDEVENT = $00000004;

// DBREASONENUM constants
type
  DBREASONENUM = TOleEnum;
const
  DBREASON_ROWSET_FETCHPOSITIONCHANGE = $00000000;
  DBREASON_ROWSET_RELEASE = $00000001;
  DBREASON_COLUMN_SET = $00000002;
  DBREASON_COLUMN_RECALCULATED = $00000003;
  DBREASON_ROW_ACTIVATE = $00000004;
  DBREASON_ROW_RELEASE = $00000005;
  DBREASON_ROW_DELETE = $00000006;
  DBREASON_ROW_FIRSTCHANGE = $00000007;
  DBREASON_ROW_INSERT = $00000008;
  DBREASON_ROW_RESYNCH = $00000009;
  DBREASON_ROW_UNDOCHANGE = $0000000A;
  DBREASON_ROW_UNDOINSERT = $0000000B;
  DBREASON_ROW_UNDODELETE = $0000000C;
  DBREASON_ROW_UPDATE = $0000000D;
  DBREASON_ROWSET_CHANGED = $0000000E;

// DBREASONENUM15 constants
type
  DBREASONENUM15 = TOleEnum;
const
  DBREASON_ROWPOSITION_CHANGED = $0000000F;
  DBREASON_ROWPOSITION_CHAPTERCHANGED = $00000010;
  DBREASON_ROWPOSITION_CLEARED = $00000011;
  DBREASON_ROW_ASYNCHINSERT = $00000012;

// DBREASONENUM25 constants
type
  DBREASONENUM25 = TOleEnum;
const
  DBREASON_ROWSET_ROWSADDED = $00000013;
  DBREASON_ROWSET_POPULATIONCOMPLETE = $00000014;
  DBREASON_ROWSET_POPULATIONSTOPPED = $00000015;

// DBCOMPAREOPSENUM constants
type
  DBCOMPAREOPSENUM = TOleEnum;
const
  DBCOMPAREOPS_LT = $00000000;
  DBCOMPAREOPS_LE = $00000001;
  DBCOMPAREOPS_EQ = $00000002;
  DBCOMPAREOPS_GE = $00000003;
  DBCOMPAREOPS_GT = $00000004;
  DBCOMPAREOPS_BEGINSWITH = $00000005;
  DBCOMPAREOPS_CONTAINS = $00000006;
  DBCOMPAREOPS_NE = $00000007;
  DBCOMPAREOPS_IGNORE = $00000008;
  DBCOMPAREOPS_CASESENSITIVE = $00001000;
  DBCOMPAREOPS_CASEINSENSITIVE = $00002000;

// DBCOMPAREOPSENUM20 constants
type
  DBCOMPAREOPSENUM20 = TOleEnum;
const
  DBCOMPAREOPS_NOTBEGINSWITH = $00000009;
  DBCOMPAREOPS_NOTCONTAINS = $0000000A;

// DBASYNCHOPENUM constants
type
  DBASYNCHOPENUM = TOleEnum;
const
  DBASYNCHOP_OPEN = $00000000;

// DBASYNCHPHASEENUM constants
type
  DBASYNCHPHASEENUM = TOleEnum;
const
  DBASYNCHPHASE_INITIALIZATION = $00000000;
  DBASYNCHPHASE_POPULATION = $00000001;
  DBASYNCHPHASE_COMPLETE = $00000002;
  DBASYNCHPHASE_CANCELED = $00000003;

// DBSORTENUM constants
type
  DBSORTENUM = TOleEnum;
const
  DBSORT_ASCENDING = $00000000;
  DBSORT_DESCENDING = $00000001;

// DBACCESSORFLAGSENUM constants
type
  DBACCESSORFLAGSENUM = TOleEnum;
const
  DBACCESSOR_INVALID = $00000000;
  DBACCESSOR_PASSBYREF = $00000001;
  DBACCESSOR_ROWDATA = $00000002;
  DBACCESSOR_PARAMETERDATA = $00000004;
  DBACCESSOR_OPTIMIZED = $00000008;

// DBACCESSORFLAGSENUM25 constants
type
  DBACCESSORFLAGSENUM25 = TOleEnum;
const
  DBACCESSOR_INHERITED = $00000010;

// DBBINDSTATUSENUM constants
type
  DBBINDSTATUSENUM = TOleEnum;
const
  DBBINDSTATUS_OK = $00000000;
  DBBINDSTATUS_BADORDINAL = $00000001;
  DBBINDSTATUS_UNSUPPORTEDCONVERSION = $00000002;
  DBBINDSTATUS_BADBINDINFO = $00000003;
  DBBINDSTATUS_BADSTORAGEFLAGS = $00000004;
  DBBINDSTATUS_NOINTERFACE = $00000005;
  DBBINDSTATUS_MULTIPLESTORAGE = $00000006;

// DBCOMPAREENUM constants
type
  DBCOMPAREENUM = TOleEnum;
const
  DBCOMPARE_LT = $00000000;
  DBCOMPARE_EQ = $00000001;
  DBCOMPARE_GT = $00000002;
  DBCOMPARE_NE = $00000003;
  DBCOMPARE_NOTCOMPARABLE = $00000004;

// DBPOSITIONFLAGSENUM constants
type
  DBPOSITIONFLAGSENUM = TOleEnum;
const
  DBPOSITION_OK = $00000000;
  DBPOSITION_NOROW = $00000001;
  DBPOSITION_BOF = $00000002;
  DBPOSITION_EOF = $00000003;

// DBPENDINGSTATUSENUM constants
type
  DBPENDINGSTATUSENUM = TOleEnum;
const
  DBPENDINGSTATUS_NEW = $00000001;
  DBPENDINGSTATUS_CHANGED = $00000002;
  DBPENDINGSTATUS_DELETED = $00000004;
  DBPENDINGSTATUS_UNCHANGED = $00000008;
  DBPENDINGSTATUS_INVALIDROW = $00000010;

// DBSEEKENUM constants
type
  DBSEEKENUM = TOleEnum;
const
  DBSEEK_INVALID = $00000000;
  DBSEEK_FIRSTEQ = $00000001;
  DBSEEK_LASTEQ = $00000002;
  DBSEEK_GE = $00000004;
  DBSEEK_GT = $00000008;
  DBSEEK_LE = $00000010;
  DBSEEK_LT = $00000020;

// DBRANGEENUM constants
type
  DBRANGEENUM = TOleEnum;
const
  DBRANGE_INCLUSIVESTART = $00000000;
  DBRANGE_INCLUSIVEEND = $00000000;
  DBRANGE_EXCLUSIVESTART = $00000001;
  DBRANGE_EXCLUSIVEEND = $00000002;
  DBRANGE_EXCLUDENULLS = $00000004;
  DBRANGE_PREFIX = $00000008;
  DBRANGE_MATCH = $00000010;

// DBRANGEENUM20 constants
type
  DBRANGEENUM20 = TOleEnum;
const
  DBRANGE_MATCH_N_SHIFT = $00000018;
  DBRANGE_MATCH_N_MASK = $000000FF;

// DBWATCHNOTIFYENUM constants
type
  DBWATCHNOTIFYENUM = TOleEnum;
const
  DBWATCHNOTIFY_ROWSCHANGED = $00000001;
  DBWATCHNOTIFY_QUERYDONE = $00000002;
  DBWATCHNOTIFY_QUERYREEXECUTED = $00000003;

// DBWATCHMODEENUM constants
type
  DBWATCHMODEENUM = TOleEnum;
const
  DBWATCHMODE_ALL = $00000001;
  DBWATCHMODE_EXTEND = $00000002;
  DBWATCHMODE_MOVE = $00000004;
  DBWATCHMODE_COUNT = $00000008;

// DBROWCHANGEKINDENUM constants
type
  DBROWCHANGEKINDENUM = TOleEnum;
const
  DBROWCHANGEKIND_INSERT = $00000000;
  DBROWCHANGEKIND_DELETE = $00000001;
  DBROWCHANGEKIND_UPDATE = $00000002;
  DBROWCHANGEKIND_COUNT = $00000003;

// DBCONVERTFLAGSENUM constants
type
  DBCONVERTFLAGSENUM = TOleEnum;
const
  DBCONVERTFLAGS_COLUMN = $00000000;
  DBCONVERTFLAGS_PARAMETER = $00000001;

// DBCONVERTFLAGSENUM20 constants
type
  DBCONVERTFLAGSENUM20 = TOleEnum;
const
  DBCONVERTFLAGS_ISLONG = $00000002;
  DBCONVERTFLAGS_ISFIXEDLENGTH = $00000004;
  DBCONVERTFLAGS_FROMVARIANT = $00000008;

// DBRESOURCEKINDENUM constants
type
  DBRESOURCEKINDENUM = TOleEnum;
const
  DBRESOURCE_INVALID = $00000000;
  DBRESOURCE_TOTAL = $00000001;
  DBRESOURCE_CPU = $00000002;
  DBRESOURCE_MEMORY = $00000003;
  DBRESOURCE_DISK = $00000004;
  DBRESOURCE_NETWORK = $00000005;
  DBRESOURCE_RESPONSE = $00000006;
  DBRESOURCE_ROWS = $00000007;
  DBRESOURCE_OTHER = $00000008;

// DBCOSTUNITENUM constants
type
  DBCOSTUNITENUM = TOleEnum;
const
  DBUNIT_INVALID = $00000000;
  DBUNIT_WEIGHT = $00000001;
  DBUNIT_PERCENT = $00000002;
  DBUNIT_MAXIMUM = $00000004;
  DBUNIT_MINIMUM = $00000008;
  DBUNIT_MICRO_SECOND = $00000010;
  DBUNIT_MILLI_SECOND = $00000020;
  DBUNIT_SECOND = $00000040;
  DBUNIT_MINUTE = $00000080;
  DBUNIT_HOUR = $00000100;
  DBUNIT_BYTE = $00000200;
  DBUNIT_KILO_BYTE = $00000400;
  DBUNIT_MEGA_BYTE = $00000800;
  DBUNIT_GIGA_BYTE = $00001000;
  DBUNIT_NUM_MSGS = $00002000;
  DBUNIT_NUM_LOCKS = $00004000;
  DBUNIT_NUM_ROWS = $00008000;
  DBUNIT_OTHER = $00010000;

// DBEXECLIMITSENUM constants
type
  DBEXECLIMITSENUM = TOleEnum;
const
  DBEXECLIMITS_ABORT = $00000001;
  DBEXECLIMITS_STOP = $00000002;
  DBEXECLIMITS_SUSPEND = $00000003;

// DBCOMMANDREUSEENUM constants
type
  DBCOMMANDREUSEENUM = TOleEnum;
const
  DBCOMMANDREUSE_NONE = $00000000;
  DBCOMMANDREUSE_PROPERTIES = $00000001;
  DBCOMMANDREUSE_PARAMETERS = $00000002;

// DBVALUEKINDENUM constants
type
  DBVALUEKINDENUM = TOleEnum;
const
  DBVALUEKIND_BYGUID = $00000100;
  DBVALUEKIND_COLDESC = $00000101;
  DBVALUEKIND_ID = $00000102;
  DBVALUEKIND_CONTENT = $00000103;
  DBVALUEKIND_CONTENTVECTOR = $00000104;
  DBVALUEKIND_GROUPINFO = $00000105;
  DBVALUEKIND_PARAMETER = $00000106;
  DBVALUEKIND_PROPERTY = $00000107;
  DBVALUEKIND_SETFUNC = $00000108;
  DBVALUEKIND_SORTINFO = $00000109;
  DBVALUEKIND_TEXT = $0000010A;
  DBVALUEKIND_COMMAND = $0000010B;
  DBVALUEKIND_MONIKER = $0000010C;
  DBVALUEKIND_ROWSET = $0000010D;
  DBVALUEKIND_LIKE = $0000010E;
  DBVALUEKIND_CONTENTPROXIMITY = $0000010F;
  DBVALUEKIND_IDISPATCH = $00000009;
  DBVALUEKIND_IUNKNOWN = $0000000D;
  DBVALUEKIND_EMPTY = $00000000;
  DBVALUEKIND_NULL = $00000001;
  DBVALUEKIND_I2 = $00000002;
  DBVALUEKIND_I4 = $00000003;
  DBVALUEKIND_R4 = $00000004;
  DBVALUEKIND_R8 = $00000005;
  DBVALUEKIND_CY = $00000006;
  DBVALUEKIND_DATE = $00000007;
  DBVALUEKIND_BSTR = $00000008;
  DBVALUEKIND_ERROR = $0000000A;
  DBVALUEKIND_BOOL = $0000000B;
  DBVALUEKIND_VARIANT = $0000000C;
  DBVALUEKIND_VECTOR = $00001000;
  DBVALUEKIND_ARRAY = $00002000;
  DBVALUEKIND_BYREF = $00004000;
  DBVALUEKIND_I1 = $00000010;
  DBVALUEKIND_UI1 = $00000011;
  DBVALUEKIND_UI2 = $00000012;
  DBVALUEKIND_UI4 = $00000013;
  DBVALUEKIND_I8 = $00000014;
  DBVALUEKIND_UI8 = $00000015;
  DBVALUEKIND_GUID = $00000048;
  DBVALUEKIND_BYTES = $00000080;
  DBVALUEKIND_STR = $00000081;
  DBVALUEKIND_WSTR = $00000082;
  DBVALUEKIND_NUMERIC = $00000083;
  DBVALUEKIND_DBDATE = $00000085;
  DBVALUEKIND_DBTIME = $00000086;
  DBVALUEKIND_DBTIMESTAMP = $00000087;

// DBSOURCETYPEENUM constants
type
  DBSOURCETYPEENUM = TOleEnum;
const
  DBSOURCETYPE_DATASOURCE = $00000001;
  DBSOURCETYPE_ENUMERATOR = $00000002;

// DBSOURCETYPEENUM20 constants
type
  DBSOURCETYPEENUM20 = TOleEnum;
const
  DBSOURCETYPE_DATASOURCE_TDP = $00000001;
  DBSOURCETYPE_DATASOURCE_MDP = $00000003;

// DBLITERALENUM constants
type
  DBLITERALENUM = TOleEnum;
const
  DBLITERAL_INVALID = $00000000;
  DBLITERAL_BINARY_LITERAL = $00000001;
  DBLITERAL_CATALOG_NAME = $00000002;
  DBLITERAL_CATALOG_SEPARATOR = $00000003;
  DBLITERAL_CHAR_LITERAL = $00000004;
  DBLITERAL_COLUMN_ALIAS = $00000005;
  DBLITERAL_COLUMN_NAME = $00000006;
  DBLITERAL_CORRELATION_NAME = $00000007;
  DBLITERAL_CURSOR_NAME = $00000008;
  DBLITERAL_ESCAPE_PERCENT = $00000009;
  DBLITERAL_ESCAPE_UNDERSCORE = $0000000A;
  DBLITERAL_INDEX_NAME = $0000000B;
  DBLITERAL_LIKE_PERCENT = $0000000C;
  DBLITERAL_LIKE_UNDERSCORE = $0000000D;
  DBLITERAL_PROCEDURE_NAME = $0000000E;
  DBLITERAL_QUOTE = $0000000F;
  DBLITERAL_SCHEMA_NAME = $00000010;
  DBLITERAL_TABLE_NAME = $00000011;
  DBLITERAL_TEXT_COMMAND = $00000012;
  DBLITERAL_USER_NAME = $00000013;
  DBLITERAL_VIEW_NAME = $00000014;

// DBLITERALENUM20 constants
type
  DBLITERALENUM20 = TOleEnum;
const
  DBLITERAL_CUBE_NAME = $00000015;
  DBLITERAL_DIMENSION_NAME = $00000016;
  DBLITERAL_HIERARCHY_NAME = $00000017;
  DBLITERAL_LEVEL_NAME = $00000018;
  DBLITERAL_MEMBER_NAME = $00000019;
  DBLITERAL_PROPERTY_NAME = $0000001A;
  DBLITERAL_SCHEMA_SEPARATOR = $0000001B;
  DBLITERAL_QUOTE_SUFFIX = $0000001C;

// ACCESS_MASKENUM constants
type
  ACCESS_MASKENUM = TOleEnum;
const
  PERM_EXCLUSIVE = $00000200;
  PERM_READDESIGN = $00000400;
  PERM_WRITEDESIGN = $00000800;
  PERM_WITHGRANT = $00001000;
  PERM_REFERENCE = $00002000;
  PERM_CREATE = $00004000;
  PERM_INSERT = $00008000;
  PERM_DELETE = $00010000;
  PERM_READCONTROL = $00020000;
  PERM_WRITEPERMISSIONS = $00040000;
  PERM_WRITEOWNER = $00080000;
  PERM_MAXIMUM_ALLOWED = $02000000;
  PERM_ALL = $10000000;
  PERM_EXECUTE = $20000000;
  PERM_READ = $80000000;
  PERM_UPDATE = $40000000;
  PERM_DROP = $00000100;

//MULTIPLE_TRUSTEE_OPERATION constants
type
  MULTIPLE_TRUSTEE_OPERATION = TOleEnum;
const
  NO_MULTIPLE_TRUSTEE = $00000000;
  TRUSTEE_IS_IMPERSONATE = $00000001;

// TRUSTEE_FORM constants
type
  TRUSTEE_FORM = TOleEnum;
const
  TRUSTEE_IS_SID = $00000000;
  TRUSTEE_IS_NAME = $00000001;
  TRUSTEE_BAD_FORM = $00000002;

// TRUSTEE_TYPE constants
type
  TRUSTEE_TYPE = TOleEnum;
const
  TRUSTEE_IS_UNKNOWN = $00000000;
  TRUSTEE_IS_USER = $00000001;
  TRUSTEE_IS_GROUP = $00000002;
  TRUSTEE_IS_DOMAIN = $00000003;
  TRUSTEE_IS_ALIAS = $00000004;
  TRUSTEE_IS_WELL_KNOWN_GROUP = $00000005;
  TRUSTEE_IS_DELETED = $00000006;
  TRUSTEE_IS_INVALID = $00000007;

// ACCESS_MODE constants
type
  ACCESS_MODE = TOleEnum;
const
  NOT_USED_ACCESS = $00000000;
  GRANT_ACCESS = $00000001;
  SET_ACCESS = $00000002;
  DENY_ACCESS = $00000003;
  REVOKE_ACCESS = $00000004;
  SET_AUDIT_SUCCESS = $00000005;
  SET_AUDIT_FAILURE = $00000006;

// DBPROPTOPTIONS constants
type
  DBPROMPTOPTIONS = TOleEnum;
const
  DBPROMPTOPTIONS_NONE = 0;
  DBPROMPTOPTIONS_WIZARDSHEET = $1;
  DBPROMPTOPTIONS_PROPERTYSHEET = $2;
  DBPROMPTOPTIONS_BROWSEONLY = $8;
  DBPROMPTOPTIONS_DISABLE_PROVIDER_SELECTION = $10;

type

// *********************************************************************//
// Declaration of structures, unions and aliases.                       //
// *********************************************************************//

  SBYTE = Shortint;
  PUintArray = IntPtr;
  TUintArray = array[0..MAXBOUND] of UINT;
  PPByte = IntPtr;
  PPByteArray = IntPtr;
  TPByteArray = array[0..MAXBOUND] of IntPtr;

  DBSTATUS = DWORD;
  DBTYPE = Word;
  DBKIND = UINT;
  DBPARAMIO = UINT;
  DBMEMOWNER = UINT;
  DBPART = UINT;
  DBPROPSTATUS = UINT;
  DBPROPOPTIONS = UINT;
  DBPROPFLAGS = UINT;
  DBBINDSTATUS = UINT;
  HWATCHREGION = UINT;
  DBINDEX_COL_ORDER = UINT;
  DBCOLUMNFLAGS = UINT;
  DBCOMMANDOP = Word;
  DBASYNCHOP = UINT;
  DBREASON = UINT;
  DBEVENTPHASE = UINT;
  DBCOLUMNDESCFLAGS = UINT;
  DBPARAMFLAGS = UINT;

  DBASYNCHPHASE = UINT;
  PDBASYNCHPHASE = IntPtr;

  DBSORT = UINT;

  DBCOMPAREOP = UINT;
  PDBCOMPAREOP = IntPtr;

  HACCESSOR = UINT;
  PHACCESSOR = IntPtr;

  HSOURCE = Word;
  PHSOURCE = IntPtr;

  HCHAPTER = UINT;
  PHCHAPTER = HCHAPTER;

  HROW = UINT;
  PHROW = IntPtr;
  PPHROW = IntPtr;

  DBROWSTATUS = UINT;
  PDBROWSTATUS = IntPtr;
  PPDBROWSTATUS = IntPtr;

  DBPENDINGSTATUS = DWORD;
  PDBPENDINGSTATUS = IntPtr;
  PPDBPENDINGSTATUS = IntPtr;

  DBROWOPTIONS = UINT;
  PDBROWOPTIONS = IntPtr;

  DBSOURCETYPE = DWORD;
  PDBSOURCETYPE = IntPtr;

  PBoid = IntPtr;
  BOID = packed record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
    rgb_: array[0..15] of Byte;
  end;
  TBoid = BOID;

  PXactTransInfo = IntPtr;
  XACTTRANSINFO = packed record
    uow: BOID;
    isoLevel: Integer;
    isoFlags: UINT;
    grfTCSupported: UINT;
    grfRMSupported: UINT;
    grfTCSupportedRetaining: UINT;
    grfRMSupportedRetaining: UINT;
  end;
  TXactTransInfo = XACTTRANSINFO;

  PXactOpt = IntPtr;
  XACTOPT = packed record
    ulTimeout: UINT;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 40)]
    szDescription: array[0..39] of Shortint;
  end;
  TXActOpt = XACTOPT;

  PXactStats = IntPtr;
  XACTSTATS = packed record
    cOpen: UINT;
    cCommitting: UINT;
    cCommitted: UINT;
    cAborting: UINT;
    cAborted: UINT;
    cInDoubt: UINT;
    cHeuristicDecision: UINT;
    timeTransactionsUp: FILETIME;
  end;
  TXactStats = XACTSTATS;

  PDBBindExt = IntPtr;
  DBBINDEXT = packed record
    pExtension: IntPtr; { PByte }
    ulExtension: UINT;
  end;
  TDBBindExt = DBBINDEXT;

  PDBObject = IntPtr;
  DBOBJECT = packed record
    dwFlags: UINT;
    iid: TGUID;
  end;
  TDBObject = DBOBJECT;

  PDBBinding = IntPtr;
  DBBINDING = packed record
    iOrdinal: UINT;
    obValue: UINT;
    obLength: UINT;
    obStatus: UINT;
    [MarshalAs(UnmanagedType.Interface)]
    pTypeInfo: ITypeInfo;
    pObject: IntPtr; { ^DBObject }
    pBindExt: IntPtr; { ^DBBindExt }
    dwPart: DBPART;
    dwMemOwner: DBMEMOWNER;
    eParamIO: DBPARAMIO;
    cbMaxLen: UINT;
    dwFlags: UINT;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBBinding = DBBINDING;

  PDBBindingArray = IntPtr;
  TDBBindingArray = array[0..MAXBOUND] of TDBBinding;

  PDBIDName = IntPtr;
  DBIDNAME = record
    case Integer of
      0: (pwszName: IntPtr); { PWideChar }
      1: (ulPropid: UINT);
  end;
  TDBIDName = DBIDNAME;

  PDBIDGuid = IntPtr;
  DBIDGUID = record
    case Integer of
      0: (guid: TGUID);
      1: (pguid: IntPtr); { ^TGUID }
  end;
  TDBIDGuid = DBIDGUID;

  DBPROPID = UINT;
  TDBPropIDArray = array[0..MAXBOUND] of DBPROPID;

  PDBID = IntPtr;
  PPDBID = IntPtr;
  DBID = packed record
    uGuid: DBIDGUID;
    eKind: DBKIND;
    uName: DBIDNAME;
  end;
  TDBID = DBID;

  PDBIDArray = IntPtr;
  TDBIDArray = array[0..MAXBOUND] of TDBID;

  PDBPropIDSet = IntPtr;
  DBPROPIDSET = packed record
    rgPropertyIDs: IntPtr; { ^DBPropIDArray }
    cPropertyIDs: UINT;
    guidPropertySet: TGUID;
  end;
  TDBPropIDSet = DBPROPIDSET;

  PDBPropIDSetArray = IntPtr;
  TDBPropIDSetArray = array[0..MAXBOUND] of TDBPropIDSet;

  PDBProp = IntPtr;
  DBPROP = packed record
    dwPropertyID: DBPROPID;
    dwOptions: DBPROPOPTIONS;
    dwStatus: DBPROPSTATUS;
    colid: DBID;
    vValue: OleVariant;
  end;
  TDBProp = DBPROP;

  PDBPropArray = IntPtr;
  TDBPropArray = array[0..MAXBOUND] of TDBProp;


  PPDBPropSet = IntPtr;
  PDBPropSet = IntPtr;
  DBPROPSET = packed record
    rgProperties: IntPtr; { ^DBPropArray }
    cProperties: UINT;
    guidPropertySet: TGUID;
  end;
  TDBPropSet = DBPROPSET;

  PDBPropSetArray = IntPtr;
  TDBPropSetArray = array[0..MAXBOUND] of TDBPropSet;

  PDBPropInfo = IntPtr;
  DBPROPINFO = packed record
    pwszDescription: IntPtr; { PWideChar }
    dwPropertyID: DBPROPID;
    dwFlags: DBPROPFLAGS;
    vtType: Word;
    vValues: OleVariant;
  end;
  TDBPropInfo = DBPROPINFO;

  PDBPropInfoArray = IntPtr;
  TDBPropInfoArray = array[0..MAXBOUND] of TDBPropInfo;

  PDBPropInfoSet = IntPtr;
  DBPROPINFOSET = packed record
    rgPropertyInfos: IntPtr; { ^DBPropInfoArray }
    cPropertyInfos: UINT;
    guidPropertySet: TGUID; 
  end;
  TDBPropInfoSet = DBPROPINFOSET;

  PDBPropInfoSetArray = IntPtr;
  TDBPropInfoSetArray = array[0..MAXBOUND] of TDBPropInfoSet;

  PDBIndexColumnDesc = IntPtr;
  DBINDEXCOLUMNDESC = packed record
    pColumnID: IntPtr; { ^DBID }
    eIndexColOrder: DBINDEX_COL_ORDER;
  end;
  TDBIndexColumnDesc = DBINDEXCOLUMNDESC;

  PDBIndexColumnDescArray = IntPtr;
  TDBIndexColumnDescArray = array[0..MAXBOUND] of TDBIndexColumnDesc;

  PDBParams = IntPtr;
  DBPARAMS = packed record
    pData: IntPtr; { Pointer }
    cParamSets: UINT;
    HACCESSOR: HACCESSOR;
  end;
  TDBParams = DBPARAMS;

  PDBColumnInfo = IntPtr;
  DBCOLUMNINFO = packed record
    pwszName: IntPtr; { PWideChar }
    [MarshalAs(UnmanagedType.Interface)]
    pTypeInfo: ITypeInfo;
    iOrdinal: UINT;
    dwFlags: DBCOLUMNFLAGS;
    ulColumnSize: UINT;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
    columnid: DBID;
  end;
  TDBColumnInfo = DBCOLUMNINFO;

  PDBColumnInfoArray = IntPtr;
  TDBColumnInfoArray = array[0..MAXCOLS] of TDBColumnInfo;

  PDBLiteralInfo = IntPtr;
  DBLITERALINFO = packed record
    pwszLiteralValue: IntPtr; { PWideChar }
    pwszInvalidChars: IntPtr; { PWideChar }
    pwszInvalidStartingChars: IntPtr; { PWideChar }
    lt: UINT;
    fSupported: BOOL;
    cchMaxLen: UINT;
  end;
  TDBLiteralInfo = DBLITERALINFO;

  PDBLiteralInfoArray = IntPtr;
  TDBLiteralInfoArray = array[0..MAXBOUND] of TDBLiteralInfo;

  PDBColumnDesc = IntPtr;
  DBCOLUMNDESC = packed record
    pwszTypeName: IntPtr; { PWideChar }
    [MarshalAs(UnmanagedType.Interface)]
    pTypeInfo: ITypeInfo;
    rgPropertySets: IntPtr; { ^DBPROPSET }
    pclsid: IntPtr; { ^TGUID }
    cPropertySets: UINT;
    ulColumnSize: UINT;
    dbcid: DBID;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBColumnDesc = DBCOLUMNDESC;

  PDBColumnDescArray = IntPtr;
  TDBColumnDescArray = array[0..MAXBOUND] of TDBColumnDesc;

  PSecObjectElement = IntPtr;
  SEC_OBJECT_ELEMENT = packed record
    guidObjectType: TGUID;
    ObjectID: DBID;
  end;
  TSecObjectElement = SEC_OBJECT_ELEMENT;

  PSecObjectElementArray = IntPtr;
  TSecObjectElementArray = array[0..MAXBOUND] of TSecObjectElement;

  PSecObject = IntPtr;
  SEC_OBJECT = packed record
    cObjects: UINT;
    prgObjects: IntPtr; { ^SecObjectElementArray }
  end;
  TSecObject = SEC_OBJECT;

  PPTrusteeW = IntPtr;
  PTrusteeW = IntPtr;
  TRUSTEE_W = packed record
    pMultipleTrustee: IntPtr; { ^TrusteeW }
    MultipleTrusteeOperation: MULTIPLE_TRUSTEE_OPERATION;
    TrusteeForm: TRUSTEE_FORM;
    TrusteeType: TRUSTEE_TYPE;
    ptstrName: IntPtr; { PWideChar }
  end;
  TTrusteeW = TRUSTEE_W;

  PDBPARAMINFO = IntPtr;
  DBPARAMINFO = packed record
    dwFlags: DBPARAMFLAGS;
    iOrdinal: UINT;
    pwszName: IntPtr; { PWideChar }
    [MarshalAs(UnmanagedType.Interface)]
    pTypeInfo: ITypeInfo;
    ulParamSize: UINT;
    wType: DBTYPE;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBParamInfo = DBPARAMINFO;

  PDBParamInfoArray = IntPtr;
  TDBParamInfoArray = array[0..MAXBOUND] of DBPARAMINFO;

  DB_NUMERIC = packed record
    precision: Byte;
    scale: Byte;
    sign: Byte;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
    val: array[0..15] of Byte;
  end;
  TDBNumeric = DB_NUMERIC;

  PDBVector = IntPtr;
  DBVECTOR = packed record
    size: UINT;
    ptr: IntPtr; { Pointer }
  end;
  TDBVector = DBVECTOR;

  PDBDate = IntPtr;
  DBDATE = packed record
    year: Smallint;
    month: Word;
    day: Word;
  end;
  TDBDate = DBDATE;

  PDBTime = IntPtr;
  DBTIME = packed record
    hour: Word;
    minute: Word;
    second: Word;
  end;
  TDBTime = DBTIME;

  PDBTimeStamp = IntPtr;
  DBTIMESTAMP = packed record
    year: Smallint;
    month: Word;
    day: Word;
    hour: Word;
    minute: Word;
    second: Word;
    fraction: UINT;
  end;
  TDBTimeStamp = DBTIMESTAMP;

  PDBFileTime = IntPtr;
  DBFILETIME = packed record
    dwLowDateTime: UINT;
    dwHighDateTime: UINT;
  end;
  TDBFileTime = DBFILETIME;
  { DBFILETIME should be FILETIME }

  PDBVarNumeric = IntPtr;
  DB_VARNUMERIC = packed record
    precision: Byte;
    scale: SBYTE;
    sign: Byte;
    val: IntPtr; { ^Byte }
  end;
  TDBVarNumeric = DB_VARNUMERIC;

  PDBFailureInfo = IntPtr;
  DBFAILUREINFO = packed record
    HROW: HROW;
    iColumn: UINT;
    failure: HResult;
  end;
  TDBFailureInfo = DBFAILUREINFO;

  PMDAxisInfo = IntPtr;
  MDAXISINFO = packed record
    cbSize: UINT;
    iAxis: UINT;
    cDimensions: UINT;
    cCoordinates: UINT;
    rgcColumns: IntPtr; { ^UINT }
    rgpwszDimensionNames: IntPtr; { ^PWideChar }
  end;
  TMDAxisInfo = MDAXISINFO;

  PDBParamBindInfo = IntPtr;
  DBPARAMBINDINFO = packed record
    pwszDataSourceType: IntPtr; { PWideChar }
    pwszName: IntPtr; { PWideChar }
    ulParamSize: UINT;
    dwFlags: DBPARAMFLAGS;
    bPrecision: Byte;
    bScale: Byte;
  end;
  TDBParamBindInfo = DBPARAMBINDINFO;

  PDBParamBindInfoArray = IntPtr;
  TDBParamBindInfoArray = array[0..MAXBOUND] of TDBParamBindInfo;

  PErrorInfo = IntPtr;
  ERRORINFO = packed record
    hrError: HResult;
    dwMinor: UINT;
    clsid: TGUID;
    iid: TGUID;
    dispid: Integer;
  end;
  TErrorInfo = ERRORINFO;

  PPExplicitAccessW = IntPtr;
  PExplicitAccessW = IntPtr;
  EXPLICIT_ACCESS_W = packed record
    grfAccessPermissions: UINT;
    grfAccessMode: ACCESS_MODE;
    grfInheritance: UINT;
    Trustee: TRUSTEE_W;
  end;
  TExplicitAccessW = EXPLICIT_ACCESS_W;

// *********************************************************************//
//  DBID Values
// *********************************************************************//

// The following consts are provided for reference only
{const
  DB_NULLID: DBID = (uguid: (guid: (D1: 0; D2: 0; D3:0; D4: (0, 0, 0, 0, 0, 0, 0, 0))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid:0));
  DBCOLUMN_IDNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 2));
  DBCOLUMN_NAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 3));
  DBCOLUMN_NUMBER: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 4));
  DBCOLUMN_TYPE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 5));
  DBCOLUMN_PRECISION: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 7));
  DBCOLUMN_SCALE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 8));
  DBCOLUMN_FLAGS: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 9));
  DBCOLUMN_BASECOLUMNNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 10));
  DBCOLUMN_BASETABLENAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 11));
  DBCOLUMN_COLLATINGSEQUENCE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 12));
  DBCOLUMN_COMPUTEMODE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 13));
  DBCOLUMN_DEFAULTVALUE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 14));
  DBCOLUMN_DOMAINNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 15));
  DBCOLUMN_HASDEFAULT: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 16));
  DBCOLUMN_ISAUTOINCREMENT: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 17));
  DBCOLUMN_ISCASESENSITIVE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 18));
  DBCOLUMN_ISSEARCHABLE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 20));
  DBCOLUMN_ISUNIQUE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 21));
  DBCOLUMN_BASECATALOGNAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 223));
  DBCOLUMN_BASESCHEMANAME: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 24));
  DBCOLUMN_GUID: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 29));
  DBCOLUMN_PROPID: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 30));
  DBCOLUMN_TYPEINFO: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 31));
  DBCOLUMN_DOMAINCATALOG: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 32));
  DBCOLUMN_DOMAINSCHEMA: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 33));
  DBCOLUMN_DATETIMEPRECISION: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 34));
  DBCOLUMN_NUMERICPRECISIONRADIX: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 35));
  DBCOLUMN_OCTETLENGTH: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 36));
  DBCOLUMN_COLUMNSIZE: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 37));
  DBCOLUMN_CLSID: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 38));
  DBCOLUMN_BASETABLEVERSION: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 40));
  DBCOLUMN_KEYCOLUMN: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 41));
  DBCOLUMN_MAYSORT: DBID = (uguid: (guid: (D1: $0C733A81; D2: $2A1C; D3:$11CE; D4: ($AD,$E5,$00,$AA,$00,$44,$77,$3D))); ekind: DBKIND_GUID_PROPID; uname: (ulpropid: 39));
}

type

// *********************************************************************//
// Interface: ITransaction
// GUID:      {0FB15084-AF41-11CE-BD2B-204C4F4F5020}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0FB15084-AF41-11CE-BD2B-204C4F4F5020'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransaction = interface // (IUnknown)
    [PreserveSig]
    function Commit(fRetaining: BOOL; grfTC: UINT; grfRM: UINT): HResult;
    [PreserveSig]
    function Abort(pboidReason: PBOID; fRetaining: BOOL; fAsync: BOOL): HResult;
    [PreserveSig]
    function GetTransactionInfo(out pinfo: XACTTRANSINFO): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0FB15084-AF41-11CE-BD2B-204C4F4F5020'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionSC = interface // (IUnknown)
    procedure Commit(fRetaining: BOOL; grfTC: UINT; grfRM: UINT);
    procedure Abort(pboidReason: PBOID; fRetaining: BOOL; fAsync: BOOL);
    procedure GetTransactionInfo(out pinfo: XACTTRANSINFO);
  end;

// *********************************************************************//
// Interface: ITransactionOptions
// GUID:      {3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD}
// *********************************************************************//
  [ComImport,
  GuidAttribute('3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionOptions = interface // (IUnknown)
    [PreserveSig]
    function SetOptions(var pOptions: XACTOPT): HResult;
    [PreserveSig]
    function GetOptions(var pOptions: XACTOPT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionOptionsSC = interface // (IUnknown)
    procedure SetOptions(var pOptions: XACTOPT);
    procedure GetOptions(var pOptions: XACTOPT);
  end;

// *********************************************************************//
// Interface: ITransactionDispenser
// GUID:      {3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD}
// *********************************************************************//
  [ComImport,
  GuidAttribute('3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionDispenser = interface // (IUnknown)
    [PreserveSig]
    function GetOptionsObject([MarshalAs(UnmanagedType.Interface)] out ppOptions: ITransactionOptions): HResult;
    [PreserveSig]
    function BeginTransaction([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      isoLevel: Integer; isoFlags: UINT;
      [in, MarshalAs(UnmanagedType.Interface)] var pOptions: ITransactionOptions;
      [MarshalAs(UnmanagedType.Interface)] out ppTransaction: ITransaction): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionDispenserSC = interface // (IUnknown)
    procedure GetOptionsObject([MarshalAs(UnmanagedType.Interface)] out ppOptions: ITransactionOptions);
    procedure BeginTransaction([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      isoLevel: Integer; isoFlags: UINT;
      [in, MarshalAs(UnmanagedType.Interface)] var pOptions: ITransactionOptions;
      [MarshalAs(UnmanagedType.Interface)] out ppTransaction: ITransaction);
  end;

// *********************************************************************//
// Interface: ITransactionOutcomeEvents
// GUID:      {3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD}
// *********************************************************************//
  [ComImport,
  GuidAttribute('3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionOutcomeEvents = interface // (IUnknown)
    [PreserveSig]
    function Committed(fRetaining: BOOL; pNewUOW: PBOID; hr: HResult): HResult;
    [PreserveSig]
    function Aborted(pboidReason: PBOID; fRetaining: BOOL;
      pNewUOW: PBOID; hr: HResult): HResult;
    [PreserveSig]
    function HeuristicDecision(dwDecision: UINT; pboidReason: PBOID;
      hr: HResult): HResult;
    [PreserveSig]
    function Indoubt: HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionOutcomeEventsSC = interface // (IUnknown)
    procedure Committed(fRetaining: BOOL; pNewUOW: PBOID; hr: HResult);
    procedure Aborted(pboidReason: PBOID; fRetaining: BOOL;
      pNewUOW: PBOID; hr: HResult);
    procedure HeuristicDecision(dwDecision: UINT; pboidReason: PBOID;
      hr: HResult);
    [PreserveSig]
    function Indoubt: HResult;
  end;

// *********************************************************************//
// Interface: IAccessor
// GUID:      {0C733A8C-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A8C-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAccessor = interface // (IUnknown)
    [PreserveSig]
    function AddRefAccessor(HACCESSOR: HACCESSOR; pcRefCount: IntPtr {PUINT}): HResult;
    [PreserveSig]
    function CreateAccessor(dwAccessorFlags: UINT; cBindings: UINT;
      [in] rgBindings: array of TDBBinding; cbRowSize: UINT;
      var phAccessor: HACCESSOR; rgStatus: PUintArray): HResult;
    [PreserveSig]
    function GetBindings(HACCESSOR: HACCESSOR; pdwAccessorFlags: IntPtr {PUINT};
      var pcBindings: UINT; out prgBindings: PDBBinding): HResult;
    [PreserveSig]
    function ReleaseAccessor(HACCESSOR: HACCESSOR; pcRefCount: IntPtr {PUINT}): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A8C-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAccessorSC = interface // (IUnknown)
    procedure AddRefAccessor(HACCESSOR: HACCESSOR; pcRefCount: IntPtr {PUINT});
    procedure CreateAccessor(dwAccessorFlags: UINT; cBindings: UINT;
      [in] rgBindings: array of TDBBinding; cbRowSize: UINT;
      var phAccessor: HACCESSOR; rgStatus: PUintArray);
    procedure GetBindings(HACCESSOR: HACCESSOR; pdwAccessorFlags: IntPtr {PUINT};
      var pcBindings: UINT; out prgBindings: PDBBinding);
    procedure ReleaseAccessor(HACCESSOR: HACCESSOR; pcRefCount: IntPtr {PUINT});
  end;

// *********************************************************************//
// Interface: IRowset
// GUID:      {0C733A7C-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A7C-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowset = interface // (IUnknown)
    [PreserveSig]
    function AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray): HResult;
    [PreserveSig]
    function ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function RestartPosition(hReserved: HCHAPTER): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A7C-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetSC = interface // (IUnknown)
    procedure AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray);
    procedure GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer});
    procedure GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray);
    procedure ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray);
    procedure RestartPosition(hReserved: HCHAPTER);
  end;

// *********************************************************************//
// Interface: IRowsetInfo
// GUID:      {0C733A55-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A55-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetInfo = interface // (IUnknown)
    [PreserveSig]
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      out pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult;
    [PreserveSig]
    function GetReferencedRowset(iOrdinal: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppReferencedRowset): HResult;
    [PreserveSig]
    function GetSpecification([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSpecification): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A55-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetInfoSC = interface // (IUnknown)
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      out pcPropertySets: UINT; out prgPropertySets: PDBPropSet);
    procedure GetReferencedRowset(iOrdinal: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppReferencedRowset);
    procedure GetSpecification([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSpecification);
  end;

// *********************************************************************//
// Interface: IRowsetLocate
// GUID:      {0C733A7D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A7D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetLocate = interface // (IRowset)
    // IRowset
    [PreserveSig]
    function AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray): HResult;
    [PreserveSig]
    function ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function RestartPosition(hReserved: HCHAPTER): HResult;

    // IRowsetLocate
    function Compare(hReserved: HCHAPTER; cbBookmark1: UINT; pBookmark1: IntPtr {PByte};
      cbBookmark2: UINT; pBookmark2: IntPtr {PByte}; out pComparison: UINT): HResult;
    function GetRowsAt(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; cbBookmark: UINT;
      pBookmark: IntPtr {PByte}; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; out prghRows: PHROW): HResult;
    function GetRowsByBookmark(hReserved: HCHAPTER; cRows: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rghRows, rgRowStatus: PUintArray): HResult;
    function Hash(hReserved: HCHAPTER; cBookmarks: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rgHashedValues,
        rgBookmarkStatus: PUintArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A7D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetLocateSC = interface // (IRowsetSC)
    // IRowsetSC
    procedure AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray);
    procedure GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer});
    procedure GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray);
    procedure ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray);
    procedure RestartPosition(hReserved: HCHAPTER);

    // IRowsetLocateSC
    procedure Compare(hReserved: HCHAPTER; cbBookmark1: UINT; pBookmark1: IntPtr {PByte};
      cbBookmark2: UINT; pBookmark2: IntPtr {PByte}; out pComparison: UINT);
    procedure GetRowsAt(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; cbBookmark: UINT;
      pBookmark: IntPtr {PByte}; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; out prghRows: PHROW);
    procedure GetRowsByBookmark(hReserved: HCHAPTER; cRows: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rghRows, rgRowStatus: PUintArray);
    procedure Hash(hReserved: HCHAPTER; cBookmarks: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rgHashedValues,
        rgBookmarkStatus: PUintArray);
  end;

// *********************************************************************//
// Interface: IRowsetResynch
// GUID:      {0C733A84-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A84-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetResynch = interface // (IUnknown)
    [PreserveSig]
    function GetVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      out pData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function ResynchRows(cRows: UINT; rghRows: PUintArray; pcRowsResynched: IntPtr {PUINT};
      out prghRowsResynched: PHROW; prgRowStatus: PPDBROWSTATUS): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A84-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetResynchSC = interface // (IUnknown)
    procedure GetVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      out pData: IntPtr {Pointer});
    procedure ResynchRows(cRows: UINT; rghRows: PUintArray; pcRowsResynched: IntPtr {PUINT};
      out prghRowsResynched: PHROW; prgRowStatus: PPDBROWSTATUS);
  end;

// *********************************************************************//
// Interface: IRowsetScroll
// GUID:      {0C733A7E-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A7E-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetScroll = interface // (IRowsetLocate)
    // IRowset
    [PreserveSig]
    function AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray): HResult;
    [PreserveSig]
    function ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function RestartPosition(hReserved: HCHAPTER): HResult;

    // IRowsetLocate
    [PreserveSig]
    function Compare(hReserved: HCHAPTER; cbBookmark1: UINT; pBookmark1: IntPtr {PByte};
      cbBookmark2: UINT; pBookmark2: IntPtr {PByte}; out pComparison: UINT): HResult;
    [PreserveSig]
    function GetRowsAt(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; cbBookmark: UINT;
      pBookmark: IntPtr {PByte}; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; out prghRows: PHROW): HResult;
    [PreserveSig]
    function GetRowsByBookmark(hReserved: HCHAPTER; cRows: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rghRows, rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function Hash(hReserved: HCHAPTER; cBookmarks: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rgHashedValues,
        rgBookmarkStatus: PUintArray): HResult;

    // IRowsetScroll
    function GetApproximatePosition(hReserved: HCHAPTER; cbBookmark: UINT; pBookmark: IntPtr {PByte};
      pulPosition: IntPtr {PUINT}; pcRows: IntPtr {PUINT}): HResult;
    function GetRowsAtRatio(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; ulNumerator: UINT;
      ulDenominator: UINT; cRows: Integer; out pcRowsObtained: UINT;
      var prghRows: PHROW): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A7E-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetScrollSC = interface // (IRowsetLocateSC)
    // IRowsetSC
    procedure AddRefRows(cRows: UINT; rghRows: PUintArray; rgRefCounts: PUintArray;
      rgRowStatus: PUintArray);
    procedure GetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer});
    procedure GetNextRows(hReserved: HCHAPTER; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; var prghRows: PUintArray);
    procedure ReleaseRows(cRows: UINT; rghRows: PUintArray; rgRowOptions,
      rgRefCounts, rgRowStatus: PUintArray);
    procedure RestartPosition(hReserved: HCHAPTER);

    // IRowsetLocateSC
    procedure Compare(hReserved: HCHAPTER; cbBookmark1: UINT; pBookmark1: IntPtr {PByte};
      cbBookmark2: UINT; pBookmark2: IntPtr {PByte}; out pComparison: UINT);
    procedure GetRowsAt(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; cbBookmark: UINT;
      pBookmark: IntPtr {PByte}; lRowsOffset: Integer; cRows: Integer;
      out pcRowsObtained: UINT; out prghRows: PHROW);
    procedure GetRowsByBookmark(hReserved: HCHAPTER; cRows: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rghRows, rgRowStatus: PUintArray);
    procedure Hash(hReserved: HCHAPTER; cBookmarks: UINT; rgcbBookmarks: PUintArray;
      rgpBookmarks: PPByteArray; rgHashedValues,
        rgBookmarkStatus: PUintArray);

    // IRowsetScrollSC
    procedure GetApproximatePosition(hReserved: HCHAPTER; cbBookmark: UINT; pBookmark: IntPtr {PByte};
      pulPosition: IntPtr {PUINT}; pcRows: IntPtr {PUINT});
    procedure GetRowsAtRatio(hReserved1: HWATCHREGION; hReserved2: HCHAPTER; ulNumerator: UINT;
      ulDenominator: UINT; cRows: Integer; out pcRowsObtained: UINT;
      var prghRows: PHROW);
  end;

// *********************************************************************//
// Interface: IRowsetChange
// GUID:      {0C733A05-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A05-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetChange = interface // (IUnknown)
    [PreserveSig]
    function DeleteRows(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function SetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function InsertRow(hReserved: HCHAPTER; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer};
      phRow: PHROW): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A05-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetChangeSC = interface // (IUnknown)
    procedure DeleteRows(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgRowStatus: PUintArray);
    procedure SetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer});
    procedure InsertRow(hReserved: HCHAPTER; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer};
      phRow: PHROW);
  end;

// *********************************************************************//
// Interface: IRowsetUpdate
// GUID:      {0C733A6D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A6D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetUpdate = interface // (IRowsetChange)
    // IRowsetChange
    [PreserveSig]
    function DeleteRows(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgRowStatus: PUintArray): HResult;
    [PreserveSig]
    function SetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function InsertRow(hReserved: HCHAPTER; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer};
      phRow: PHROW): HResult;

    // IRowsetUpdate
    [PreserveSig]
    function GetOriginalData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function GetPendingRows(hReserved: HCHAPTER; dwRowStatus: DBPENDINGSTATUS; pcPendingRows: IntPtr {PUINT};
      prgPendingRows: PPHROW; prgPendingStatus: PPDBPENDINGSTATUS): HResult;
    [PreserveSig]
    function GetRowStatus(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgPendingStatus: PUintArray): HResult;
    [PreserveSig]
    function Undo(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRowsUndone: IntPtr {PUINT};
      prgRowsUndone: PPHROW; prgRowStatus: PPDBROWSTATUS): HResult;
    [PreserveSig]
    function Update(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRows: IntPtr {PUINT};
      prgRows: PPHROW; prgRowStatus: PPDBROWSTATUS): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A6D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetUpdateSC = interface // (IRowsetChangeSC)
    // IRowsetChangeSC
    procedure DeleteRows(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgRowStatus: PUintArray);
    procedure SetData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer});
    procedure InsertRow(hReserved: HCHAPTER; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer};
      phRow: PHROW);

    // IRowsetUpdateSC
    procedure GetOriginalData(HROW: HROW; HACCESSOR: HACCESSOR; pData: IntPtr {Pointer});
    procedure GetPendingRows(hReserved: HCHAPTER; dwRowStatus: DBPENDINGSTATUS; pcPendingRows: IntPtr {PUINT};
      prgPendingRows: PPHROW; prgPendingStatus: PPDBPENDINGSTATUS);
    procedure GetRowStatus(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      rgPendingStatus: PUintArray);
    procedure Undo(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRowsUndone: IntPtr {PUINT};
      prgRowsUndone: PPHROW; prgRowStatus: PPDBROWSTATUS);
    procedure Update(hReserved: HCHAPTER; cRows: UINT; rghRows: PUintArray; pcRows: IntPtr {PUINT};
      prgRows: PPHROW; prgRowStatus: PPDBROWSTATUS);
  end;

// *********************************************************************//
// Interface: IRowsetIndex
// GUID:      {0C733A82-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A82-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetIndex = interface // (IUnknown)
    [PreserveSig]
    function GetIndexInfo(var pcKeyColumns: UINT; out prgIndexColumnDesc: PDBINDEXCOLUMNDESC;
      var pcIndexProperties: UINT; out prgIndexProperties: PDBPropSet): HResult;
    [PreserveSig]
    function Seek(HACCESSOR: HACCESSOR; cKeyValues: UINT; pData: IntPtr {Pointer};
      dwSeekOptions: UINT): HResult;
    [PreserveSig]
    function SetRange(HACCESSOR: HACCESSOR; cStartKeyColumns: UINT; pStartData: IntPtr {Pointer};
      cEndKeyColumns: UINT; pEndData: IntPtr {Pointer}; dwRangeOptions: UINT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A82-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetIndexSC = interface // (IUnknown)
    procedure GetIndexInfo(var pcKeyColumns: UINT; out prgIndexColumnDesc: PDBINDEXCOLUMNDESC;
      var pcIndexProperties: UINT; out prgIndexProperties: PDBPropSet);
    procedure Seek(HACCESSOR: HACCESSOR; cKeyValues: UINT; pData: IntPtr {Pointer};
      dwSeekOptions: UINT);
    procedure SetRange(HACCESSOR: HACCESSOR; cStartKeyColumns: UINT; pStartData: IntPtr {Pointer};
      cEndKeyColumns: UINT; pEndData: IntPtr {Pointer}; dwRangeOptions: UINT);
  end;

// *********************************************************************//
// Interface: IMultipleResults
// GUID:      {0C733A90-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A90-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMultipleResults = interface // (IUnknown)
    [PreserveSig]
    function GetResult([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      reserved: Integer; [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      pcRowsAffected: IntPtr {PInteger};
      [MarshalAs(UnmanagedType.IUnknown)] var ppRowset): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A90-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMultipleResultsSC = interface // (IUnknown)
    procedure GetResult([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      reserved: Integer; [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      pcRowsAffected: IntPtr {PInteger};
      [MarshalAs(UnmanagedType.IUnknown)] var ppRowset);
  end;

// *********************************************************************//
// Interface: IConvertType
// GUID:      {0C733A88-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A88-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IConvertType = interface // (IUnknown)
    [PreserveSig]
    function CanConvert(wFromType: DBTYPE; wToType: DBTYPE;
      dwConvertFlags: UINT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A88-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IConvertTypeSC = interface // (IUnknown)
    procedure CanConvert(wFromType: DBTYPE; wToType: DBTYPE;
      dwConvertFlags: UINT);
  end;

// *********************************************************************//
// Interface: ICommandPrepare
// GUID:      {0C733A26-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A26-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandPrepare = interface //(IUnknown)
    [PreserveSig]
    function Prepare(cExpectedRuns: UINT): HResult;
    [PreserveSig]
    function Unprepare: HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A26-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandPrepareSC = interface // (IUnknown)
    procedure Prepare(cExpectedRuns: UINT);
    procedure Unprepare;
  end;

// *********************************************************************//
// Interface: ICommandProperties
// GUID:      {0C733A79-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A79-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandProperties = interface // (IUnknown)
    [PreserveSig]
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult;
    [PreserveSig]
    function SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A79-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandPropertiesSC = interface // (IUnknown)
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet);
    procedure SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray);
  end;

// *********************************************************************//
// Interface: ICommand
// GUID:      {0C733A63-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A63-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommand = interface //(IUnknown)
    [PreserveSig]
    function Cancel: HResult;
    [PreserveSig]
    function Execute([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; var pParams: DBPARAMS;
      pcRowsAffected: IntPtr; {PInteger}
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset): HResult;
    [PreserveSig]
    function GetDBSession([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSession): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A63-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandSC = interface // (IUnknown)
    procedure Cancel;
    procedure Execute([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; var pParams: DBPARAMS;
      pcRowsAffected: IntPtr; {PInteger}
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset);
    procedure GetDBSession([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSession);
  end;

// *********************************************************************//
// Interface: ICommandWithParameters
// GUID:      {0C733A64-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A64-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandWithParameters = interface //(IUnknown)
    [PreserveSig]
    function GetParameterInfo(var pcParams: UINT; out prgParamInfo: PDBPARAMINFO;
      ppNamesBuffer: IntPtr {PPOleStr}): HResult;
    [PreserveSig]
    function MapParameterNames(cParamNames: UINT; rgParamNames: IntPtr; {POleStrList}
      rgParamOrdinals: PUintArray): HResult;
    [PreserveSig]
    function SetParameterInfo(cParams: UINT; rgParamOrdinals: PUintArray;
      rgParamBindInfo: PDBParamBindInfoArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A64-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandWithParametersSC = interface // (IUnknown)
    procedure GetParameterInfo(var pcParams: UINT; out prgParamInfo: PDBPARAMINFO;
      ppNamesBuffer: IntPtr {PPOleStr});
    procedure MapParameterNames(cParamNames: UINT; rgParamNames: IntPtr {POleStrList};
      rgParamOrdinals: PUintArray);
    procedure SetParameterInfo(cParams: UINT; rgParamOrdinals: PUintArray;
      rgParamBindInfo: PDBParamBindInfoArray);
  end;

// *********************************************************************//
// Interface: ICommandText
// GUID:      {0C733A27-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A27-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandText = interface // (ICommand)
    // ICommand
    [PreserveSig]
    function Cancel: HResult;
    [PreserveSig]
    function Execute([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; var pParams: DBPARAMS;
      pcRowsAffected: IntPtr; {PInteger}
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset): HResult;
    [PreserveSig]
    function GetDBSession([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSession): HResult;

    // ICommandText
    [PreserveSig]
    function GetCommandText(var pguidDialect: TGUID;
      out ppwszCommand: IntPtr {PWideChar}): HResult;
    [PreserveSig]
    function SetCommandText([MarshalAs(UnmanagedType.LPStruct)] guidDialect: TGUID;
      pwszCommand: IntPtr {PWideChar}): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A27-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandTextSC = interface // (ICommandSC)
    // ICommandSC
    procedure Cancel;
    procedure Execute([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; var pParams: DBPARAMS;
      pcRowsAffected: IntPtr; {PInteger}
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset);
    procedure GetDBSession([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSession);

    // ICommandTextSC
    procedure GetCommandText(var pguidDialect: TGUID;
      out ppwszCommand: IntPtr {PWideChar});
    procedure SetCommandText([MarshalAs(UnmanagedType.LPStruct)] guidDialect: TGUID;
      pwszCommand: IntPtr {PWideChar});
  end;

// *********************************************************************//
// Interface: IColumnsRowset
// GUID:      {0C733A10-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A10-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IColumnsRowset = interface // (IUnknown)
    [PreserveSig]
    function GetAvailableColumns(var pcOptColumns: UINT;
      var prgOptColumns: PDBID): HResult;
    [PreserveSig]
    function GetColumnsRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      cOptColumns: UINT; rgOptColumns: PDBIDArray;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] out pColRowset): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A10-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IColumnsRowsetSC = interface // (IUnknown)
    procedure GetAvailableColumns(var pcOptColumns: UINT;
      var prgOptColumns: PDBID);
    procedure GetColumnsRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      cOptColumns: UINT; rgOptColumns: PDBIDArray;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] out pColRowset);
  end;

// *********************************************************************//
// Interface: IColumnsInfo
// GUID:      {0C733A11-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A11-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IColumnsInfo = interface //(IUnknown)
    [PreserveSig]
    function GetColumnInfo(var pcColumns: UINT; out prgInfo: PDBColumnInfo;
      out ppStringsBuffer: IntPtr {PWideChar}): HResult;
    [PreserveSig]
    function MapColumnIDs(cColumnIDs: UINT; rgColumnIDs: PDBIDArray;
      rgColumns: PUintArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A11-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IColumnsInfoSC = interface // (IUnknown)
    procedure GetColumnInfo(var pcColumns: UINT; out prgInfo: PDBColumnInfo;
      out ppStringsBuffer: IntPtr {PWideChar});
    procedure MapColumnIDs(cColumnIDs: UINT; rgColumnIDs: PDBIDArray;
      rgColumns: PUintArray);
  end;

// *********************************************************************//
// Interface: IDBCreateCommand
// GUID:      {0C733A1D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A1D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBCreateCommand = interface // (IUnknown)
    [PreserveSig]
    function CreateCommand([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppCommand): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A1D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBCreateCommandSC = interface // (IUnknown)
    procedure CreateCommand([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppCommand);
  end;

// *********************************************************************//
// Interface: IDBCreateSession
// GUID:      {0C733A5D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A5D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBCreateSession = interface // (IUnknown)
    [PreserveSig]
    function CreateSession([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppDBSession): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A5D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBCreateSessionSC = interface // (IUnknown)
    procedure CreateSession([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppDBSession);
  end;

// *********************************************************************//
// Interface: ISourcesRowset
// GUID:      {0C733A1E-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A1E-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISourcesRowset = interface //(IUnknown)
    [PreserveSig]
    function GetSourcesRowset([MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgProperties: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSourcesRowset): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A1E-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISourcesRowsetSC = interface // (IUnknown)
    procedure GetSourcesRowset([MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgProperties: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] out ppSourcesRowset);
  end;

// *********************************************************************//
// Interface: IDBProperties
// GUID:      {0C733A8A-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A8A-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBProperties = interface // (IUnknown)
    [PreserveSig]
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult;
    [PreserveSig]
    function GetPropertyInfo(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertyInfoSets: UINT; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: IntPtr {PPOleStr}): HResult;
    [PreserveSig]
    function SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A8A-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBPropertiesSC = interface // (IUnknown)
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet);
    procedure GetPropertyInfo(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertyInfoSets: UINT; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: IntPtr {PPOleStr});
    procedure SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSet);
  end;

// *********************************************************************//
// Interface: IDBInitialize
// GUID:      {0C733A8B-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A8B-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBInitialize = interface // (IUnknown)
    [PreserveSig]
    function Initialize: HResult;
    [PreserveSig]
    function Uninitialize: HResult;
  end;

  { SafeCall version }
  [ComImport,
  GuidAttribute('0C733A8B-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBInitializeSC = interface // (IUnknown)
    procedure Initialize;
    procedure Uninitialize;
  end;

// *********************************************************************//
// Interface: IDBInfo
// GUID:      {0C733A89-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A89-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBInfo = interface // (IUnknown)
    [PreserveSig]
    function GetKeywords(out ppwszKeywords: IntPtr {PWideChar}): HResult;
    [PreserveSig]
    function GetLiteralInfo(cLiterals: UINT; rgLiterals: PUintArray;
      var pcLiteralInfo: UINT; out prgLiteralInfo: PDBLiteralInfo;
      out ppCharBuffer: IntPtr {PWideChar}): HResult;
  end;

  { SafeCall Version }
  [ComImport,
  GuidAttribute('0C733A89-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBInfoSC = interface // (IUnknown)
    procedure GetKeywords(out ppwszKeywords: IntPtr {PWideChar});
    procedure GetLiteralInfo(cLiterals: UINT; rgLiterals: PUintArray;
      var pcLiteralInfo: UINT;  out prgLiteralInfo: PDBLiteralInfo;
      out ppCharBuffer: IntPtr {PWideChar});
  end;

// *********************************************************************//
// Interface: IDBDataSourceAdmin
// GUID:      {0C733A7A-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A7A-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBDataSourceAdmin = interface // (IUnknown)
    [PreserveSig]
    function CreateDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      [in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppDBSession): HResult;
    [PreserveSig]
    function DestroyDataSource: HResult;
    [PreserveSig]
    function GetCreationProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      pcPropertyInfoSets: IntPtr {PUINT}; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: IntPtr {PPOleStr}): HResult;
    [PreserveSig]
    function ModifyDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A7A-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBDataSourceAdminSC = interface // (IUnknown)
    procedure CreateDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray;
      [in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppDBSession);
    procedure DestroyDataSource;
    procedure GetCreationProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      pcPropertyInfoSets: IntPtr {PUINT}; out prgPropertyInfoSets: PDBPropInfoSet;
      ppDescBuffer: IntPtr {PPOleStr});
    procedure ModifyDataSource(cPropertySets: UINT; rgPropertySets: PDBPropSetArray);
  end;

// *********************************************************************//
// Interface: ISessionProperties
// GUID:      {0C733A85-2A1C-11CE-ADE5-00AA0044773d}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A85-2A1C-11CE-ADE5-00AA0044773d'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISessionProperties = interface // (IUnknown)
    [PreserveSig]
    function GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet): HResult;
    [PreserveSig]
    function SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A85-2A1C-11CE-ADE5-00AA0044773d'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISessionPropertiesSC = interface // (IUnknown)
    procedure GetProperties(cPropertyIDSets: UINT; rgPropertyIDSets: PDBPropIDSetArray;
      var pcPropertySets: UINT; out prgPropertySets: PDBPropSet);
    procedure SetProperties(cPropertySets: UINT; rgPropertySets: PDBPropSetArray);
  end;

// *********************************************************************//
// Interface: IIndexDefinition
// GUID:      {0C733A68-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A68-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IIndexDefinition = interface // (IUnknown)
    [PreserveSig]
    function CreateIndex(var pTableID: DBID; pIndexID: PDBID; cIndexColumnDescs: UINT;
      rgIndexColumnDescs: PDBIndexColumnDescArray; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppIndexID: PPDBID): HResult;
    [PreserveSig]
    function DropIndex(var TableID: DBID; pIndexID: PDBID): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A68-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IIndexDefinitionSC = interface // (IUnknown)
    procedure CreateIndex(var pTableID: DBID; pIndexID: PDBID; cIndexColumnDescs: UINT;
      rgIndexColumnDescs: PDBIndexColumnDescArray; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppIndexID: PPDBID);
    procedure DropIndex(var TableID: DBID; pIndexID: PDBID);
  end;

// *********************************************************************//
// Interface: ITableDefinition
// GUID:      {0C733A86-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A86-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITableDefinition = interface // (IUnknown)
    [PreserveSig]
    function CreateTable([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      pTableID: PDBID; cColumnDescs: UINT;
      rgColumnDescs: PDBColumnDescArray;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppTableID: PPDBID;
      [MarshalAs(UnmanagedType.IUnknown)] var ppRowset): HResult;
    [PreserveSig]
    function DropTable(var pTableID: DBID): HResult;
    [PreserveSig]
    function AddColumn(var pTableID: DBID; var pColumnDesc: DBCOLUMNDESC;
      ppColumnID: PPDBID): HResult;
    [PreserveSig]
    function DropColumn(var pTableID: DBID; var pColumnID: DBID): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A86-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITableDefinitionSC = interface // (IUnknown)
    procedure CreateTable([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      pTableID: PDBID; cColumnDescs: UINT;
      rgColumnDescs: PDBColumnDescArray;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray; ppTableID: PPDBID;
      [MarshalAs(UnmanagedType.IUnknown)] var ppRowset);
    procedure DropTable(var pTableID: DBID);
    procedure AddColumn(var pTableID: DBID; var pColumnDesc: DBCOLUMNDESC;
      ppColumnID: PPDBID);
    procedure DropColumn(var pTableID: DBID; var pColumnID: DBID);
  end;

// *********************************************************************//
// Interface: IOpenRowset
// GUID:      {0C733A69-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A69-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOpenRowset = interface // (IUnknown)
    [PreserveSig]
    function OpenRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      pTableID: PDBID; pIndexID: PDBID;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] var ppRowset): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A69-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOpenRowsetSC = interface // (IUnknown)
    procedure OpenRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      pTableID: PDBID; pIndexID: PDBID;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] var ppRowset);
  end;

// *********************************************************************//
// Interface: IErrorLookup
// GUID:      {0C733A66-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A66-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IErrorLookup = interface // (IUnknown)
    [PreserveSig]
    function GetErrorDescription(hrError: HResult; dwLookupID: UINT;
      pdispparams: IntPtr {PDISPPARAMS}; lcid: UINT; out pbstrSource: IntPtr {WideString};
      out pbstrDescription: IntPtr {WideString}): HResult;
    [PreserveSig]
    function GetHelpInfo(hrError: HResult; dwLookupID: UINT; lcid: UINT;
      out pbstrHelpFile: IntPtr {WideString}; out pdwHelpContext: UINT): HResult;
    [PreserveSig]
    function ReleaseErrors(dwDynamicErrorID: UINT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A66-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IErrorLookupSC = interface // (IUnknown)
    procedure GetErrorDescription(hrError: HResult; dwLookupID: UINT;
      pdispparams: IntPtr {PDISPPARAMS}; lcid: UINT; out pbstrSource: IntPtr {WideString};
      out pbstrDescription: IntPtr {WideString});
    procedure GetHelpInfo(hrError: HResult; dwLookupID: UINT; lcid: UINT;
      out pbstrHelpFile: IntPtr {WideString}; out pdwHelpContext: UINT);
    procedure ReleaseErrors(dwDynamicErrorID: UINT);
  end;

// *********************************************************************//
// Interface: ISQLErrorInfo
// GUID:      {0C733A74-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A74-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISQLErrorInfo = interface // (IUnknown)
    [PreserveSig]
    function GetSQLInfo(out pbstrSQLState: IntPtr {WideString};
      out plNativeError: Integer): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A74-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISQLErrorInfoSC = interface // (IUnknown)
    procedure GetSQLInfo(out pbstrSQLState: IntPtr {WideString};
      out plNativeError: Integer);
  end;

// *********************************************************************//
// Interface: IGetDataSource
// GUID:      {0C733A75-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A75-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IGetDataSource = interface // (IUnknown)
    [PreserveSig]
    function GetDataSource([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppDataSource): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A75-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IGetDataSourceSC = interface // (IUnknown)
    procedure GetDataSource([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppDataSource);
  end;

// *********************************************************************//
// Interface: ITransactionLocal
// GUID:      {0C733A5F-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A5F-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionLocal = interface // (ITransaction)
    // ITransaction
    [PreserveSig]
    function Commit(fRetaining: BOOL; grfTC: UINT; grfRM: UINT): HResult;
    [PreserveSig]
    function Abort(pboidReason: PBOID; fRetaining: BOOL; fAsync: BOOL): HResult;
    [PreserveSig]
    function GetTransactionInfo(out pinfo: XACTTRANSINFO): HResult;

    // ITransactionLocal
    [PreserveSig]
    function GetOptionsObject([MarshalAs(UnmanagedType.Interface)] out ppOptions: ITransactionOptions): HResult;
    [PreserveSig]
    function StartTransaction(isoLevel: Integer; isoFlags: UINT;
      [in, MarshalAs(UnmanagedType.Interface)] var pOtherOptions: ITransactionOptions;
      pulTransactionLevel: IntPtr {PUINT}): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A5F-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionLocalSC = interface // (ITransaction)
    // ITransaction
    procedure Commit(fRetaining: BOOL; grfTC: UINT; grfRM: UINT);
    procedure Abort(pboidReason: PBOID; fRetaining: BOOL; fAsync: BOOL);
    procedure GetTransactionInfo(out pinfo: XACTTRANSINFO);

    // ITransactionLocalSC
    procedure GetOptionsObject([MarshalAs(UnmanagedType.Interface)] out ppOptions: ITransactionOptions);
    procedure StartTransaction(isoLevel: Integer; isoFlags: UINT;
      [in, MarshalAs(UnmanagedType.Interface)] var pOtherOptions: ITransactionOptions;
      pulTransactionLevel: IntPtr {PUINT});
  end;

// *********************************************************************//
// Interface: ITransactionJoin
// GUID:      {0C733A5E-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A5E-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionJoin = interface // (IUnknown)
    [PreserveSig]
    function GetOptionsObject([MarshalAs(UnmanagedType.Interface)] out ppOptions: ITransactionOptions): HResult;
    [PreserveSig]
    function JoinTransaction([in, MarshalAs(UnmanagedType.IUnknown)] punkTransactionCoord: TObject;
      isoLevel: Integer; isoFlags: UINT;
      [in, MarshalAs(UnmanagedType.Interface)] var pOtherOptions: ITransactionOptions): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A5E-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionJoinSC = interface // (IUnknown)
    procedure GetOptionsObject([MarshalAs(UnmanagedType.Interface)] out ppOptions: ITransactionOptions);
    procedure JoinTransaction([in, MarshalAs(UnmanagedType.IUnknown)] punkTransactionCoord: TObject;
      isoLevel: Integer; isoFlags: UINT;
      [in, MarshalAs(UnmanagedType.Interface)] var pOtherOptions: ITransactionOptions);
  end;

// *********************************************************************//
// Interface: ITransactionObject
// GUID:      {0C733A60-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A60-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionObject = interface // (IUnknown)
    [PreserveSig]
    function GetTransactionObject(ulTransactionLevel: UINT;
      [MarshalAs(UnmanagedType.Interface)] out ppTransactionObject: ITransaction): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A60-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionObjectSC = interface // (IUnknown)
    procedure GetTransactionObject(ulTransactionLevel: UINT;
      [MarshalAs(UnmanagedType.Interface)] out ppTransactionObject: ITransaction);
  end;

// *********************************************************************//
// Interface: IDBAsynchStatus
// GUID:      {0C733A95-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A95-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBAsynchStatus = interface // (IUnknown)
    [PreserveSig]
    function Abort(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP): HResult;
    [PreserveSig]
    function GetStatus(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP; pulProgress: IntPtr {PUINT};
      pulProgressMax: IntPtr {PUINT}; peAsynchPhase: PDBASYNCHPHASE;
      ppwszStatusText: IntPtr {PPOleStr}): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A95-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBAsynchStatusSC = interface // (IUnknown)
    procedure Abort(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP);
    procedure GetStatus(HCHAPTER: HCHAPTER; eOperation: DBASYNCHOP; pulProgress: IntPtr {PUINT};
      pulProgressMax: IntPtr {PUINT}; peAsynchPhase: PDBASYNCHPHASE;
      ppwszStatusText: IntPtr {PPOleStr});
  end;

// *********************************************************************//
// Interface: IRowsetFind
// GUID:      {0C733A9D-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A9D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetFind = interface //(IUnknown)
    [PreserveSig]
    function FindNextRow(HCHAPTER: HCHAPTER; HACCESSOR: HACCESSOR; pFindValue: IntPtr {Pointer};
      CompareOp: DBCOMPAREOP; cbBookmark: UINT; pBookmark: IntPtr {PByte};
      lRowsOffset: Integer; cRows: Integer; var pcRowsObtained: UINT;
      out prghRows: PHROW): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A9D-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetFindSC = interface // (IUnknown)
    procedure FindNextRow(HCHAPTER: HCHAPTER; HACCESSOR: HACCESSOR; pFindValue: IntPtr {Pointer};
      CompareOp: DBCOMPAREOP; cbBookmark: UINT; pBookmark: IntPtr {PByte};
      lRowsOffset: Integer; cRows: Integer; var pcRowsObtained: UINT;
      out prghRows: PHROW);
  end;

// *********************************************************************//
// Interface: IRowPosition
// GUID:      {0C733A94-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A94-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowPosition = interface // (IUnknown)
    [PreserveSig]
    function ClearRowPosition: HResult;
    [PreserveSig]
    function GetRowPosition(out phChapter: HCHAPTER; out phRow: HROW;
      out pdwPositionFlags: UINT): HResult;
    [PreserveSig]
    function GetRowset([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset): HResult;
    [PreserveSig]
    function Initialize([in, MarshalAs(UnmanagedType.IUnknown)] pRowset: TObject): HResult;
    [PreserveSig]
    function SetRowPosition(HCHAPTER: HCHAPTER; HROW: HROW; dwPositionFlags: UINT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A94-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowPositionSC = interface // (IUnknown)
    procedure ClearRowPosition;
    procedure GetRowPosition(out phChapter: HCHAPTER; out phRow: HROW;
      out pdwPositionFlags: UINT);
    procedure GetRowset([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset);
    procedure Initialize([in, MarshalAs(UnmanagedType.IUnknown)] pRowset: TObject);
    procedure SetRowPosition(HCHAPTER: HCHAPTER; HROW: HROW; dwPositionFlags: UINT);
  end;

// *********************************************************************//
// Interface: IRowPositionChange
// GUID:      {0997A571-126E-11D0-9F8A-00A0C9A0631E}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0997A571-126E-11D0-9F8A-00A0C9A0631E'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowPositionChange = interface // (IUnknown)
    [PreserveSig]
    function OnRowPositionChange(eReason: DBREASON; ePhase: DBEVENTPHASE;
      fCantDeny: BOOL): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0997A571-126E-11D0-9F8A-00A0C9A0631E'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowPositionChangeSC = interface // (IUnknown)
    procedure OnRowPositionChange(eReason: DBREASON; ePhase: DBEVENTPHASE;
      fCantDeny: BOOL);
  end;

// *********************************************************************//
// Interface: IViewRowset
// GUID:      {0C733A97-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A97-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewRowset = interface // (IUnknown)
    [PreserveSig]
    function GetSpecification([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppObject): HResult;
    [PreserveSig]
    function OpenViewRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A97-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewRowsetSC = interface // (IUnknown)
    procedure GetSpecification([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppObject);
    procedure OpenViewRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset);
  end;

// *********************************************************************//
// Interface: IViewChapter
// GUID:      {0C733A98-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A98-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewChapter = interface // (IUnknown)
    [PreserveSig]
    function GetSpecification([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset): HResult;
    [PreserveSig]
    function OpenViewChapter(hSource: HCHAPTER; out phViewChapter: HCHAPTER): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A98-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewChapterSC = interface // (IUnknown)
    procedure GetSpecification([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset);
    procedure OpenViewChapter(hSource: HCHAPTER; out phViewChapter: HCHAPTER);
  end;

// *********************************************************************//
// Interface: IViewSort
// GUID:      {0C733A9A-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A9A-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewSort = interface // (IUnknown)
    [PreserveSig]
    function GetSortOrder(out pcValues: UINT; out prgColumns: PUintArray;
      out prgOrders: PUintArray): HResult;
    [PreserveSig]
    function SetSortOrder(cValues: UINT; rgColumns: PUintArray;
      rgOrders: PUintArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A9A-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewSortSC = interface // (IUnknown)
    procedure GetSortOrder(out pcValues: UINT; out prgColumns: PUintArray;
      out prgOrders: PUintArray);
    procedure SetSortOrder(cValues: UINT; rgColumns: PUintArray;
      rgOrders: PUintArray);
  end;

// *********************************************************************//
// Interface: IViewFilter
// GUID:      {0C733A9B-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A9B-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewFilter = interface // (IUnknown)
    [PreserveSig]
    function GetFilter(HACCESSOR: HACCESSOR; out pcRows: UINT; out pCompareOps: PDBCOMPAREOP;
      pCriteriaData: IntPtr {Pointer}): HResult;
    [PreserveSig]
    function GetFilterBindings(out pcBindings: UINT; out prgBindings: PDBBinding): HResult;
    [PreserveSig]
    function SetFilter(HACCESSOR: HACCESSOR; cRows: UINT; var CompareOps: DBCOMPAREOP;
      pCriteriaData: IntPtr {Pointer}): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A9B-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewFilterSC = interface // (IUnknown)
    procedure GetFilter(HACCESSOR: HACCESSOR; out pcRows: UINT; out pCompareOps: PDBCOMPAREOP;
      pCriteriaData: IntPtr {Pointer});
    procedure GetFilterBindings(out pcBindings: UINT; out prgBindings: PDBBinding);
    procedure SetFilter(HACCESSOR: HACCESSOR; cRows: UINT; var CompareOps: DBCOMPAREOP;
      pCriteriaData: IntPtr {Pointer});
  end;

// *********************************************************************//
// Interface: IRowsetView
// GUID:      {0C733A99-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733A99-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetView = interface // (IUnknown)
    [PreserveSig]
    function CreateView([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppView): HResult;
    [PreserveSig]
    function GetView(HCHAPTER: HCHAPTER;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; out phChapterSource: HCHAPTER;
      [MarshalAs(UnmanagedType.IUnknown)] out ppView): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733A99-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetViewSC = interface // (IUnknown)
    procedure CreateView([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppView);
    procedure GetView(HCHAPTER: HCHAPTER;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; out phChapterSource: HCHAPTER;
      [MarshalAs(UnmanagedType.IUnknown)] out ppView);
  end;

// *********************************************************************//
// Interface: IMDFind
// GUID:      {A07CCCD2-8148-11D0-87BB-00C04FC33942}
// *********************************************************************//
  [ComImport,
  GuidAttribute('A07CCCD2-8148-11D0-87BB-00C04FC33942'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMDFind = interface // (IUnknown)
    [PreserveSig]
    function FindCell(ulStartingOrdinal: UINT; cMembers: UINT; rgpwszMember: IntPtr {PPOleStr};
      out pulCellOrdinal: UINT): HResult;
    [PreserveSig]
    function FindTuple(ulAxisIdentifier: UINT; ulStartingOrdinal: UINT; cMembers: UINT;
      rgpwszMember: IntPtr {PPOleStr}; out pulTupleOrdinal: UINT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('A07CCCD2-8148-11D0-87BB-00C04FC33942'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMDFindSC = interface // (IUnknown)
    procedure FindCell(ulStartingOrdinal: UINT; cMembers: UINT; rgpwszMember: IntPtr {PPOleStr};
      out pulCellOrdinal: UINT);
    procedure FindTuple(ulAxisIdentifier: UINT; ulStartingOrdinal: UINT; cMembers: UINT;
      rgpwszMember: IntPtr {PPOleStr}; out pulTupleOrdinal: UINT);
  end;

// *********************************************************************//
// Interface: IMDRangeRowset
// GUID:      {0C733AA0-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA0-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMDRangeRowset = interface // (IUnknown)
    [PreserveSig]
    function GetRangeRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      ulStartCell: UINT; ulEndCell: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA0-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMDRangeRowsetSC = interface // (IUnknown)
    procedure GetRangeRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      ulStartCell: UINT; ulEndCell: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset);
  end;

// *********************************************************************//
// Interface: IAlterTable
// GUID:      {0C733AA5-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA5-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAlterTable = interface // (IUnknown)
    [PreserveSig]
    function AlterColumn(var pTableID: DBID; var pColumnID: DBID;
      ColumnDescFlags: DBCOLUMNDESCFLAGS; var pColumnDesc: DBCOLUMNDESC): HResult;
    [PreserveSig]
    function AlterTable(var pTableID: DBID; pNewTableId: PDBID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA5-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAlterTableSC = interface // (IUnknown)
    procedure AlterColumn(var pTableID: DBID; var pColumnID: DBID;
      ColumnDescFlags: DBCOLUMNDESCFLAGS; var pColumnDesc: DBCOLUMNDESC);
    procedure AlterTable(var pTableID: DBID; pNewTableId: PDBID; cPropertySets: UINT;
      rgPropertySets: PDBPropSetArray);
  end;

// *********************************************************************//
// Interface: IAlterIndex
// GUID:      {0C733AA6-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA6-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAlterIndex = interface // (IUnknown)
    [PreserveSig]
    function AlterIndex(var pTableID: DBID; var pIndexID: DBID; pNewIndexId: PDBID;
      cPropertySets: UINT; rgPropertySet: PDBPropSetArray): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA6-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAlterIndexSC = interface // (IUnknown)
    procedure AlterIndex(var pTableID: DBID; var pIndexID: DBID; pNewIndexId: PDBID;
      cPropertySets: UINT; rgPropertySet: PDBPropSetArray);
  end;

// *********************************************************************//
// Interface: ICommandPersist
// GUID:      {0C733AA7-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA7-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandPersist = interface // (IUnknown)
    [PreserveSig]
    function DeleteCommand(var pCommandID: DBID): HResult;
    [PreserveSig]
    function GetCurrentCommand(out ppCommandID: PDBID): HResult;
    [PreserveSig]
    function LoadCommand(var pCommandID: DBID; dwFlags: UINT): HResult;
    [PreserveSig]
    function SaveCommand(var pCommandID: DBID; dwFlags: UINT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA7-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICommandPersistSC = interface // (IUnknown)
    procedure DeleteCommand(var pCommandID: DBID);
    procedure GetCurrentCommand(out ppCommandID: PDBID);
    procedure LoadCommand(var pCommandID: DBID; dwFlags: UINT);
    procedure SaveCommand(var pCommandID: DBID; dwFlags: UINT);
  end;

// *********************************************************************//
// Interface: IRowsetChapterMember
// GUID:      {0C733AA8-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA8-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetChapterMember = interface // (IUnknown)
    [PreserveSig]
    function IsRowInChapter(HCHAPTER: HCHAPTER; HROW: HROW): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA8-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetChapterMemberSC = interface // (IUnknown)
    procedure IsRowInChapter(HCHAPTER: HCHAPTER; HROW: HROW);
  end;

// *********************************************************************//
// Interface: IRowsetRefresh
// GUID:      {0C733AA9-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA9-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetRefresh = interface // (IUnknown)
    [PreserveSig]
    function RefreshVisibleData(HCHAPTER: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      fOverWrite: BOOL; pcRowsRefreshed: IntPtr {PUINT};
      out prghRowsRefreshed: PHROW; prgRowStatus: PPDBROWSTATUS): HResult;
    [PreserveSig]
    function GetLastVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      pData: IntPtr {Pointer}): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA9-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRowsetRefreshSC = interface // (IUnknown)
    procedure RefreshVisibleData(HCHAPTER: HCHAPTER; cRows: UINT; rghRows: PUintArray;
      fOverWrite: BOOL; pcRowsRefreshed: IntPtr {PUINT};
      out prghRowsRefreshed: PHROW; prgRowStatus: PPDBROWSTATUS);
    procedure GetLastVisibleData(HROW: HROW; HACCESSOR: HACCESSOR;
      pData: IntPtr {Pointer});
  end;

// *********************************************************************//
// Interface: IParentRowset
// GUID:      {0C733AAA-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AAA-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IParentRowset = interface // (IUnknown)
    [PreserveSig]
    function GetChildRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      iOrdinal: UINT; [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AAA-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IParentRowsetSC = interface // (IUnknown)
    procedure GetChildRowset([in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
      iOrdinal: UINT; [MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] out ppRowset);
  end;

// *********************************************************************//
// Interface: ITrusteeGroupAdmin
// GUID:      {0C733AA2-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA2-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITrusteeGroupAdmin = interface // (IUnknown)
    [PreserveSig]
    function AddMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW): HResult;
    [PreserveSig]
    function DeleteMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW): HResult;
    [PreserveSig]
    function IsMember(pMembershipTrustee: PTrusteeW; pMemberTrustee: PTrusteeW;
      out pfStatus: BOOL): HResult;
    [PreserveSig]
    function GetMembers(pMembershipTrustee: PTrusteeW; pcMembers: IntPtr {PUINT};
      out prgMembers: PTrusteeW): HResult;
    [PreserveSig]
    function GetMemberships(pTrustee: PTrusteeW; pcMemberships: IntPtr {PUINT};
      out prgMemberships: PTrusteeW): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA2-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITrusteeGroupAdminSC = interface // (IUnknown)
    procedure AddMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW);
    procedure DeleteMember(pMembershipTrustee: PTrusteeW;
      pMemberTrustee: PTrusteeW);
    procedure IsMember(pMembershipTrustee: PTrusteeW; pMemberTrustee: PTrusteeW;
      out pfStatus: BOOL);
    procedure GetMembers(pMembershipTrustee: PTrusteeW; pcMembers: IntPtr {PUINT};
      out prgMembers: PTrusteeW);
    procedure GetMemberships(pTrustee: PTrusteeW; pcMemberships: IntPtr {PUINT};
      out prgMemberships: PTrusteeW);
  end;

// *********************************************************************//
// Interface: IObjectAccessControl
// GUID:      {0C733AA3-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA3-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IObjectAccessControl = interface // (IUnknown)
    [PreserveSig]
    function GetObjectAccessRights(pObject: PSecObject; pcAccessEntries: IntPtr {PUINT};
      prgAccessEntries: PExplicitAccessW): HResult;
    [PreserveSig]
    function GetObjectOwner(pObject: PSecObject; ppOwner: PPTrusteeW): HResult;
    [PreserveSig]
    function IsObjectAccessAllowed(pObject: PSecObject; pAccessEntry: PExplicitAccessW;
      pfResult: IntPtr {PBOOL}): HResult;
    [PreserveSig]
    function SetObjectAccessRights(pObject: PSecObject; cAccessEntries: UINT;
      prgAccessEntries: PExplicitAccessW): HResult;
    [PreserveSig]
    function SetObjectOwner(pObject: PSecObject; pOwner: PTrusteeW): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA3-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IObjectAccessControlSC = interface // (IUnknown)
    procedure GetObjectAccessRights(pObject: PSecObject; pcAccessEntries: IntPtr {PUINT};
      prgAccessEntries: PExplicitAccessW);
    procedure GetObjectOwner(pObject: PSecObject; ppOwner: PPTrusteeW);
    procedure IsObjectAccessAllowed(pObject: PSecObject; pAccessEntry: PExplicitAccessW;
      pfResult: IntPtr {PBOOL});
    procedure SetObjectAccessRights(pObject: PSecObject; cAccessEntries: UINT;
      prgAccessEntries: PExplicitAccessW);
    procedure SetObjectOwner(pObject: PSecObject; pOwner: PTrusteeW);
  end;

// *********************************************************************//
// Interface: ISecurityInfo
// GUID:      {0C733AA4-2A1C-11CE-ADE5-00AA0044773D}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0C733AA4-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISecurityInfo = interface // (IUnknown)
    [PreserveSig]
    function GetCurrentTrustee(ppTrustee: PPTrusteeW): HResult;
    [PreserveSig]
    function GetObjectTypes(out cObjectTypes: UINT; out rgObjectTypes: IntPtr {PGUID}): HResult;
    [PreserveSig]
    function GetPermissions(ObjectType: TGUID; out pPermissions: UINT): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('0C733AA4-2A1C-11CE-ADE5-00AA0044773D'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISecurityInfoSC = interface // (IUnknown)
    procedure GetCurrentTrustee(ppTrustee: PPTrusteeW);
    procedure GetObjectTypes(out cObjectTypes: UINT; out rgObjectTypes: IntPtr {PGUID});
    procedure GetPermissions(ObjectType: TGUID; out pPermissions: UINT);
  end;

// *********************************************************************//
// Interface: IDBPromptInitialize
// GUID:      {2206CCB0-19C1-11D1-89E0-00C04FD7A829}
// *********************************************************************//
  [ComImport,
  GuidAttribute('2206CCB0-19C1-11D1-89E0-00C04FD7A829'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBPromptInitialize = interface //(IUnknown)
    [PreserveSig]
    function PromptDataSource([in, MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject;
      hWndParent: HWND; dwPromptOptions: DBPROMPTOPTIONS;
      cSourceTypeFilter: ULONG; rgSourceTypeFilter: PDBSOURCETYPE;
      [MarshalAs(UnmanagedType.LPWStr)] pszProviderFilter: string;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TIID;
      [MarshalAs(UnmanagedType.Interface)] var DataSource): HResult;
    [PreserveSig]
    function PromptFileName(hWndParent: HWND; dwPromptOptions: DBPROMPTOPTIONS;
      [MarshalAs(UnmanagedType.LPWStr)] pwszInitialDirectory, pwszInitialFile: string;
      var ppwszSelectedFile: IntPtr {POleStr}): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('2206CCB0-19C1-11D1-89E0-00C04FD7A829'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDBPromptInitializeSC = interface // (IUnknown)
    procedure PromptDataSource([in, MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject;
      hWndParent: HWND; dwPromptOptions: DBPROMPTOPTIONS;
      cSourceTypeFilter: ULONG; rgSourceTypeFilter: PDBSOURCETYPE;
      [MarshalAs(UnmanagedType.LPWStr)] pszProviderFilter: string;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TIID;
      [MarshalAs(UnmanagedType.Interface)] var DataSource);
    procedure PromptFileName(hWndParent: HWND; dwPromptOptions: DBPROMPTOPTIONS;
      [MarshalAs(UnmanagedType.LPWStr)] pwszInitialDirectory, pwszInitialFile: string;
      var ppwszSelectedFile: IntPtr {POleStr});
  end;

// *********************************************************************//
// Interface: IDataInitialize
// GUID:      {2206CCB1-19C1-11D1-89E0-00C04FD7A829}
// *********************************************************************//
  [ComImport,
  GuidAttribute('2206CCB1-19C1-11D1-89E0-00C04FD7A829'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDataInitialize = interface //(IUnknown)
    [PreserveSig]
    function GetDataSource([MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject;
      dwClsCtx: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] pwszInitializationString: string;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TIID;
      [MarshalAs(UnmanagedType.IUnknown)] var DataSource): HResult;
    [PreserveSig]
    function GetInitializationString([MarshalAs(UnmanagedType.IUnknown)] DataSource: TObject;
      fIncludePassword: Boolean; out pwszInitString: IntPtr {POleStr}): HResult;
    [PreserveSig]
    function CreateDBInstance([MarshalAs(UnmanagedType.LPStruct)] clsidProvider: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject; dwClsCtx: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] pwszReserved: string; riid: TIID;
      [MarshalAs(UnmanagedType.IUnknown)] var DataSource: TObject): HResult;
    [PreserveSig]
    function CreateDBInstanceEx([MarshalAs(UnmanagedType.LPStruct)] clsidProvider: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject; dwClsCtx: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] pwszReserved: string;
      var pServerInfo: TCoServerInfo; cmq: ULONG; var rgmqResults: TMultiQI): HResult;
    [PreserveSig]
    function LoadStringFromStorage([MarshalAs(UnmanagedType.LPWStr)] pwszFileName: string;
      out pwszInitializationString: IntPtr {POleStr}): HResult;
    [PreserveSig]
    function WriteStringToStorage([MarshalAs(UnmanagedType.LPWStr)] pwszFileName,
      pwszInitializationString: string; dwCreationDisposition: DWORD): HResult;
  end;

  { Safecall Version }
  [ComImport,
  GuidAttribute('2206CCB1-19C1-11D1-89E0-00C04FD7A829'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDataInitializeSC = interface // (IUnknown)
    procedure GetDataSource([MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject;
      dwClsCtx: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] pwszInitializationString: string;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TIID;
      [MarshalAs(UnmanagedType.IUnknown)] var DataSource);
    procedure GetInitializationString([MarshalAs(UnmanagedType.IUnknown)] DataSource: TObject;
      fIncludePassword: Boolean; out pwszInitString: IntPtr {POleStr});
    procedure CreateDBInstance([MarshalAs(UnmanagedType.LPStruct)] clsidProvider: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject; dwClsCtx: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] pwszReserved: string; riid: TIID;
      [MarshalAs(UnmanagedType.IUnknown)] var DataSource: TObject);
    procedure CreateDBInstanceEx([MarshalAs(UnmanagedType.LPStruct)] clsidProvider: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] pUnkOuter: TObject; dwClsCtx: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] pwszReserved: string;
      var pServerInfo: TCoServerInfo; cmq: ULONG; var rgmqResults: TMultiQI);
    procedure LoadStringFromStorage([MarshalAs(UnmanagedType.LPWStr)] pwszFileName: string;
      out pwszInitializationString: IntPtr {POleStr});
    procedure WriteStringToStorage([MarshalAs(UnmanagedType.LPWStr)] pwszFileName,
      pwszInitializationString: string; dwCreationDisposition: DWORD);
  end;

// *********************************************************************//
// Error Constants from OLEDBERR.H
// *********************************************************************//

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +-+-+-+-+-+---------------------+-------------------------------+
//  |S|R|C|N|r|    Facility         |               Code            |
//  +-+-+-+-+-+---------------------+-------------------------------+
//
//  where
//
//      S - Severity - indicates success/fail
//
//          0 - Success
//          1 - Fail (COERROR)
//
//      R - reserved portion of the facility code, corresponds to NT's
//              second severity bit.
//
//      C - reserved portion of the facility code, corresponds to NT's
//              C field.
//
//      N - reserved portion of the facility code. Used to indicate a
//              mapped NT status value.
//
//      r - reserved portion of the facility code. Reserved for internal
//              use. Used to indicate HRESULT values that are not status
//              values, but are instead message ids for display strings.
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
const
  FACILITY_WINDOWS                     = $8;
  FACILITY_ITF                         = $4;


//
// Define the severity codes
//
  STATUS_SEVERITY_SUCCESS              = $0;
  STATUS_SEVERITY_COERROR              = $2;


//
// MessageId: DB_E_BOGUS
//
// MessageText:
//
//  Dummy error - need this error so that mc puts the above defines
//  inside the FACILITY_WINDOWS guard, instead of leaving it empty
//
  DB_E_BOGUS                           = HResult($80040EFF);


//
// Codes 0x0e00-0x0eff are reserved for the OLE DB group of
// interfaces.
//
// Free codes are:
//
// Error:
//   -none-
//
// Success:
//   0x0eea
//   0x0ed7
//


//
// MessageId: DB_E_BADACCESSORHANDLE
//
// MessageText:
//
//  Invalid accessor
//
  DB_E_BADACCESSORHANDLE               = HResult($80040E00);

//
// MessageId: DB_E_ROWLIMITEXCEEDED
//
// MessageText:
//
//  Creating another row would have exceeded the total number of active
//  rows supported by the rowset
//
  DB_E_ROWLIMITEXCEEDED                = HResult($80040E01);

//
// MessageId: DB_E_READONLYACCESSOR
//
// MessageText:
//
//  Unable to write with a read-only accessor
//
  DB_E_READONLYACCESSOR                = HResult($80040E02);

//
// MessageId: DB_E_SCHEMAVIOLATION
//
// MessageText:
//
//  Given values violate the database schema
//
  DB_E_SCHEMAVIOLATION                 = HResult($80040E03);

//
// MessageId: DB_E_BADROWHANDLE
//
// MessageText:
//
//  Invalid row handle
//
  DB_E_BADROWHANDLE                    = HResult($80040E04);

//
// MessageId: DB_E_OBJECTOPEN
//
// MessageText:
//
//  An object was open
//
  DB_E_OBJECTOPEN                      = HResult($80040E05);

// @@@+ V1.5
//
// MessageId: DB_E_BADCHAPTER
//
// MessageText:
//
//  Invalid chapter
//
  DB_E_BADCHAPTER                      = HResult($80040E06);

// @@@- V1.5

//
// MessageId: DB_E_CANTCONVERTVALUE
//
// MessageText:
//
//  A literal value in the command could not be converted to the
//  correct type due to a reason other than data overflow
//
  DB_E_CANTCONVERTVALUE                = HResult($80040E07);

//
// MessageId: DB_E_BADBINDINFO
//
// MessageText:
//
//  Invalid binding info
//
  DB_E_BADBINDINFO                     = HResult($80040E08);

//
// MessageId: DB_SEC_E_PERMISSIONDENIED
//
// MessageText:
//
//  Permission denied
//
  DB_SEC_E_PERMISSIONDENIED            = HResult($80040E09);

//
// MessageId: DB_E_NOTAREFERENCECOLUMN
//
// MessageText:
//
//  Specified column does not contain bookmarks or chapters
//
  DB_E_NOTAREFERENCECOLUMN             = HResult($80040E0A);

// @@@+ V2.5
//
// MessageId: DB_E_LIMITREJECTED
//
// MessageText:
//
//  Some cost limits were rejected
//
  DB_E_LIMITREJECTED                   = HResult($80040E0B);

// @@@- V2.5

//
// MessageId: DB_E_NOCOMMAND
//
// MessageText:
//
//  No command has been set for the command object
//
  DB_E_NOCOMMAND                       = HResult($80040E0C);

// @@@+ V2.5
//
// MessageId: DB_E_COSTLIMIT
//
// MessageText:
//
//  Unable to find a query plan within the given cost limit
//
  DB_E_COSTLIMIT                       = HResult($80040E0D);

// @@@- V2.5

//
// MessageId: DB_E_BADBOOKMARK
//
// MessageText:
//
//  Invalid bookmark
//
  DB_E_BADBOOKMARK                     = HResult($80040E0E);

//
// MessageId: DB_E_BADLOCKMODE
//
// MessageText:
//
//  Invalid lock mode
//
  DB_E_BADLOCKMODE                     = HResult($80040E0F);

//
// MessageId: DB_E_PARAMNOTOPTIONAL
//
// MessageText:
//
//  No value given for one or more required parameters
//
  DB_E_PARAMNOTOPTIONAL                = HResult($80040E10);

//
// MessageId: DB_E_BADCOLUMNID
//
// MessageText:
//
//  Invalid column ID
//
  DB_E_BADCOLUMNID                     = HResult($80040E11);

//
// MessageId: DB_E_BADRATIO
//
// MessageText:
//
//  Invalid ratio
//
  DB_E_BADRATIO                        = HResult($80040E12);

// @@@+ V2.0
//
// MessageId: DB_E_BADVALUES
//
// MessageText:
//
//  Invalid value
//
  DB_E_BADVALUES                       = HResult($80040E13);

// @@@- V2.0

//
// MessageId: DB_E_ERRORSINCOMMAND
//
// MessageText:
//
//  The command contained one or more errors
//
  DB_E_ERRORSINCOMMAND                 = HResult($80040E14);

//
// MessageId: DB_E_CANTCANCEL
//
// MessageText:
//
//  The executing command cannot be canceled
//
  DB_E_CANTCANCEL                      = HResult($80040E15);

//
// MessageId: DB_E_DIALECTNOTSUPPORTED
//
// MessageText:
//
//  The provider does not support the specified dialect
//
  DB_E_DIALECTNOTSUPPORTED             = HResult($80040E16);

//
// MessageId: DB_E_DUPLICATEDATASOURCE
//
// MessageText:
//
//  A data source with the specified name already exists
//
  DB_E_DUPLICATEDATASOURCE             = HResult($80040E17);

//
// MessageId: DB_E_CANNOTRESTART
//
// MessageText:
//
//  The rowset was built over a live data feed and cannot be restarted
//
  DB_E_CANNOTRESTART                   = HResult($80040E18);

//
// MessageId: DB_E_NOTFOUND
//
// MessageText:
//
//  No key matching the described characteristics could be found within
//  the current range
//
  DB_E_NOTFOUND                        = HResult($80040E19);

//
// MessageId: DB_E_NEWLYINSERTED
//
// MessageText:
//
//  The provider is unable to determine identity for newly inserted
//  rows
//
  DB_E_NEWLYINSERTED                   = HResult($80040E1B);

// @@@+ V2.5
//
// MessageId: DB_E_CANNOTFREE
//
// MessageText:
//
//  Ownership of this tree has been given to the provider
//
  DB_E_CANNOTFREE                      = HResult($80040E1A);

//
// MessageId: DB_E_GOALREJECTED
//
// MessageText:
//
//  No nonzero weights specified for any goals supported, so goal was
//  rejected; current goal was not changed
//
  DB_E_GOALREJECTED                    = HResult($80040E1C);

// @@@- V2.5

//
// MessageId: DB_E_UNSUPPORTEDCONVERSION
//
// MessageText:
//
//  Requested conversion is not supported
//
  DB_E_UNSUPPORTEDCONVERSION           = HResult($80040E1D);

//
// MessageId: DB_E_BADSTARTPOSITION
//
// MessageText:
//
//  lRowsOffset would position you past either end of the rowset,
//  regardless of the cRows value specified; cRowsObtained is 0
//
  DB_E_BADSTARTPOSITION                = HResult($80040E1E);

// @@@+ V2.0
//
// MessageId: DB_E_NOQUERY
//
// MessageText:
//
//  Information was requested for a query, and the query was not set
//
  DB_E_NOQUERY                         = HResult($80040E1F);

// @@@- V2.0

//
// MessageId: DB_E_NOTREENTRANT
//
// MessageText:
//
//  Provider called a method from IRowsetNotify in the consumer and the
//  method has not yet returned
//
  DB_E_NOTREENTRANT                    = HResult($80040E20);

//
// MessageId: DB_E_ERRORSOCCURRED
//
// MessageText:
//
//  Errors occurred
//
  DB_E_ERRORSOCCURRED                  = HResult($80040E21);

//
// MessageId: DB_E_NOAGGREGATION
//
// MessageText:
//
//  A non-NULL controlling IUnknown was specified and the object being
//  created does not support aggregation
//
  DB_E_NOAGGREGATION                   = HResult($80040E22);

//
// MessageId: DB_E_DELETEDROW
//
// MessageText:
//
//  A given HROW referred to a hard- or soft-deleted row
//
  DB_E_DELETEDROW                      = HResult($80040E23);

//
// MessageId: DB_E_CANTFETCHBACKWARDS
//
// MessageText:
//
//  The rowset does not support fetching backwards
//
  DB_E_CANTFETCHBACKWARDS              = HResult($80040E24);

//
// MessageId: DB_E_ROWSNOTRELEASED
//
// MessageText:
//
//  All HROWs must be released before new ones can be obtained
//
  DB_E_ROWSNOTRELEASED                 = HResult($80040E25);

//
// MessageId: DB_E_BADSTORAGEFLAG
//
// MessageText:
//
//  One of the specified storage flags was not supported
//
  DB_E_BADSTORAGEFLAG                  = HResult($80040E26);

// @@@+ V1.5
//
// MessageId: DB_E_BADCOMPAREOP
//
// MessageText:
//
//  The comparison operator was invalid
//
  DB_E_BADCOMPAREOP                    = HResult($80040E27);

// @@@- V1.5

//
// MessageId: DB_E_BADSTATUSVALUE
//
// MessageText:
//
//  The specified status flag was neither DBCOLUMNSTATUS_OK nor
//  DBCOLUMNSTATUS_ISNULL
//
  DB_E_BADSTATUSVALUE                  = HResult($80040E28);

//
// MessageId: DB_E_CANTSCROLLBACKWARDS
//
// MessageText:
//
//  The rowset cannot scroll backwards
//
  DB_E_CANTSCROLLBACKWARDS             = HResult($80040E29);

// @@@+ V2.5
//
// MessageId: DB_E_BADREGIONHANDLE
//
// MessageText:
//
//  Invalid region handle
//
  DB_E_BADREGIONHANDLE                 = HResult($80040E2A);

//
// MessageId: DB_E_NONCONTIGUOUSRANGE
//
// MessageText:
//
//  The specified set of rows was not contiguous to or overlapping the
//  rows in the specified watch region
//
  DB_E_NONCONTIGUOUSRANGE              = HResult($80040E2B);

//
// MessageId: DB_E_INVALIDTRANSITION
//
// MessageText:
//
//  A transition from ALL* to MOVE* or EXTEND* was specified
//
  DB_E_INVALIDTRANSITION               = HResult($80040E2C);

//
// MessageId: DB_E_NOTASUBREGION
//
// MessageText:
//
//  The specified region is not a proper subregion of the region
//  identified by the given watch region handle
//
  DB_E_NOTASUBREGION                   = HResult($80040E2D);

// @@@- V2.5

//
// MessageId: DB_E_MULTIPLESTATEMENTS
//
// MessageText:
//
//  The provider does not support multi-statement commands
//
  DB_E_MULTIPLESTATEMENTS              = HResult($80040E2E);

//
// MessageId: DB_E_INTEGRITYVIOLATION
//
// MessageText:
//
//  A specified value violated the integrity constraints for a column or
//  table
//
  DB_E_INTEGRITYVIOLATION              = HResult($80040E2F);

//
// MessageId: DB_E_BADTYPENAME
//
// MessageText:
//
//  The given type name was unrecognized
//
  DB_E_BADTYPENAME                     = HResult($80040E30);

//
// MessageId: DB_E_ABORTLIMITREACHED
//
// MessageText:
//
//  Execution aborted because a resource limit has been reached; no
//  results have been returned
//
  DB_E_ABORTLIMITREACHED               = HResult($80040E31);

// @@@+ V2.0
//
// MessageId: DB_E_ROWSETINCOMMAND
//
// MessageText:
//
//  Cannot clone a command object whose command tree contains a rowset
//  or rowsets
//
  DB_E_ROWSETINCOMMAND                 = HResult($80040E32);

//
// MessageId: DB_E_CANTTRANSLATE
//
// MessageText:
//
//  Cannot represent the current tree as text
//
  DB_E_CANTTRANSLATE                   = HResult($80040E33);

// @@@- V2.0

//
// MessageId: DB_E_DUPLICATEINDEXID
//
// MessageText:
//
//  The specified index already exists
//
  DB_E_DUPLICATEINDEXID                = HResult($80040E34);

//
// MessageId: DB_E_NOINDEX
//
// MessageText:
//
//  The specified index does not exist
//
  DB_E_NOINDEX                         = HResult($80040E35);

//
// MessageId: DB_E_INDEXINUSE
//
// MessageText:
//
//  The specified index was in use
//
  DB_E_INDEXINUSE                      = HResult($80040E36);

//
// MessageId: DB_E_NOTABLE
//
// MessageText:
//
//  The specified table does not exist
//
  DB_E_NOTABLE                         = HResult($80040E37);

//
// MessageId: DB_E_CONCURRENCYVIOLATION
//
// MessageText:
//
//  The rowset was using optimistic concurrency and the value of a
//  column has been changed since it was last read
//
  DB_E_CONCURRENCYVIOLATION            = HResult($80040E38);

//
// MessageId: DB_E_BADCOPY
//
// MessageText:
//
//  Errors were detected during the copy
//
  DB_E_BADCOPY                         = HResult($80040E39);

//
// MessageId: DB_E_BADPRECISION
//
// MessageText:
//
//  A specified precision was invalid
//
  DB_E_BADPRECISION                    = HResult($80040E3A);

//
// MessageId: DB_E_BADSCALE
//
// MessageText:
//
//  A specified scale was invalid
//
  DB_E_BADSCALE                        = HResult($80040E3B);

//
// MessageId: DB_E_BADTABLEID
//
// MessageText:
//
//  Invalid table ID
//
  DB_E_BADTABLEID                      = HResult($80040E3C);

// DB_E_BADID is deprecated; use DB_E_BADTABLEID instead
  DB_E_BADID     = DB_E_BADTABLEID;

//
// MessageId: DB_E_BADTYPE
//
// MessageText:
//
//  A specified type was invalid
//
  DB_E_BADTYPE                         = HResult($80040E3D);

//
// MessageId: DB_E_DUPLICATECOLUMNID
//
// MessageText:
//
//  A column ID was occurred more than once in the specification
//
  DB_E_DUPLICATECOLUMNID               = HResult($80040E3E);

//
// MessageId: DB_E_DUPLICATETABLEID
//
// MessageText:
//
//  The specified table already exists
//
  DB_E_DUPLICATETABLEID                = HResult($80040E3F);

//
// MessageId: DB_E_TABLEINUSE
//
// MessageText:
//
//  The specified table was in use
//
  DB_E_TABLEINUSE                      = HResult($80040E40);

//
// MessageId: DB_E_NOLOCALE
//
// MessageText:
//
//  The specified locale ID was not supported
//
  DB_E_NOLOCALE                        = HResult($80040E41);

//
// MessageId: DB_E_BADRECORDNUM
//
// MessageText:
//
//  The specified record number is invalid
//
  DB_E_BADRECORDNUM                    = HResult($80040E42);

//
// MessageId: DB_E_BOOKMARKSKIPPED
//
// MessageText:
//
//  Although the bookmark was validly formed, no row could be found to
//  match it
//
  DB_E_BOOKMARKSKIPPED                 = HResult($80040E43);

//
// MessageId: DB_E_BADPROPERTYVALUE
//
// MessageText:
//
//  The value of a property was invalid
//
  DB_E_BADPROPERTYVALUE                = HResult($80040E44);

//
// MessageId: DB_E_INVALID
//
// MessageText:
//
//  The rowset was not chaptered
//
  DB_E_INVALID                         = HResult($80040E45);

//
// MessageId: DB_E_BADACCESSORFLAGS
//
// MessageText:
//
//  Invalid accessor
//
  DB_E_BADACCESSORFLAGS                = HResult($80040E46);

//
// MessageId: DB_E_BADSTORAGEFLAGS
//
// MessageText:
//
//  Invalid storage flags
//
  DB_E_BADSTORAGEFLAGS                 = HResult($80040E47);

//
// MessageId: DB_E_BYREFACCESSORNOTSUPPORTED
//
// MessageText:
//
//  By-ref accessors are not supported by this provider
//
  DB_E_BYREFACCESSORNOTSUPPORTED       = HResult($80040E48);

//
// MessageId: DB_E_NULLACCESSORNOTSUPPORTED
//
// MessageText:
//
//  Null accessors are not supported by this provider
//
  DB_E_NULLACCESSORNOTSUPPORTED        = HResult($80040E49);

//
// MessageId: DB_E_NOTPREPARED
//
// MessageText:
//
//  The command was not prepared
//
  DB_E_NOTPREPARED                     = HResult($80040E4A);

//
// MessageId: DB_E_BADACCESSORTYPE
//
// MessageText:
//
//  The specified accessor was not a parameter accessor
//
  DB_E_BADACCESSORTYPE                 = HResult($80040E4B);

//
// MessageId: DB_E_WRITEONLYACCESSOR
//
// MessageText:
//
//  The given accessor was write-only
//
  DB_E_WRITEONLYACCESSOR               = HResult($80040E4C);

//
// MessageId: DB_SEC_E_AUTH_FAILED
//
// MessageText:
//
//  Authentication failed
//
  DB_SEC_E_AUTH_FAILED                 = HResult($80040E4D);

//
// MessageId: DB_E_CANCELED
//
// MessageText:
//
//  The change was canceled during notification; no columns are changed
//
  DB_E_CANCELED                        = HResult($80040E4E);

// @@@+ V2.0
//
// MessageId: DB_E_CHAPTERNOTRELEASED
//
// MessageText:
//
//  The rowset was single-chaptered and the chapter was not released
//
  DB_E_CHAPTERNOTRELEASED              = HResult($80040E4F);

// @@@- V2.0

//
// MessageId: DB_E_BADSOURCEHANDLE
//
// MessageText:
//
//  Invalid source handle
//
  DB_E_BADSOURCEHANDLE                 = HResult($80040E50);

//
// MessageId: DB_E_PARAMUNAVAILABLE
//
// MessageText:
//
//  The provider cannot derive parameter info and SetParameterInfo has
//  not been called
//
  DB_E_PARAMUNAVAILABLE                = HResult($80040E51);

//
// MessageId: DB_E_ALREADYINITIALIZED
//
// MessageText:
//
//  The data source object is already initialized
//
  DB_E_ALREADYINITIALIZED              = HResult($80040E52);

//
// MessageId: DB_E_NOTSUPPORTED
//
// MessageText:
//
//  The provider does not support this method
//
  DB_E_NOTSUPPORTED                    = HResult($80040E53);

//
// MessageId: DB_E_MAXPENDCHANGESEXCEEDED
//
// MessageText:
//
//  The number of rows with pending changes has exceeded the set limit
//
  DB_E_MAXPENDCHANGESEXCEEDED          = HResult($80040E54);

//
// MessageId: DB_E_BADORDINAL
//
// MessageText:
//
//  The specified column did not exist
//
  DB_E_BADORDINAL                      = HResult($80040E55);

//
// MessageId: DB_E_PENDINGCHANGES
//
// MessageText:
//
//  There are pending changes on a row with a reference count of zero
//
  DB_E_PENDINGCHANGES                  = HResult($80040E56);

//
// MessageId: DB_E_DATAOVERFLOW
//
// MessageText:
//
//  A literal value in the command overflowed the range of the type of
//  the associated column
//
  DB_E_DATAOVERFLOW                    = HResult($80040E57);

//
// MessageId: DB_E_BADHRESULT
//
// MessageText:
//
//  The supplied HRESULT was invalid
//
  DB_E_BADHRESULT                      = HResult($80040E58);

//
// MessageId: DB_E_BADLOOKUPID
//
// MessageText:
//
//  The supplied LookupID was invalid
//
  DB_E_BADLOOKUPID                     = HResult($80040E59);

//
// MessageId: DB_E_BADDYNAMICERRORID
//
// MessageText:
//
//  The supplied DynamicErrorID was invalid
//
  DB_E_BADDYNAMICERRORID               = HResult($80040E5A);

//
// MessageId: DB_E_PENDINGINSERT
//
// MessageText:
//
//  Unable to get visible data for a newly-inserted row that has not
//  yet been updated
//
  DB_E_PENDINGINSERT                   = HResult($80040E5B);

//
// MessageId: DB_E_BADCONVERTFLAG
//
// MessageText:
//
//  Invalid conversion flag
//
  DB_E_BADCONVERTFLAG                  = HResult($80040E5C);

//
// MessageId: DB_E_BADPARAMETERNAME
//
// MessageText:
//
//  The given parameter name was unrecognized
//
  DB_E_BADPARAMETERNAME                = HResult($80040E5D);

//
// MessageId: DB_E_MULTIPLESTORAGE
//
// MessageText:
//
//  Multiple storage objects can not be open simultaneously
//
  DB_E_MULTIPLESTORAGE                 = HResult($80040E5E);

//
// MessageId: DB_E_CANTFILTER
//
// MessageText:
//
//  The requested filter could not be opened
//
  DB_E_CANTFILTER                      = HResult($80040E5F);

//
// MessageId: DB_E_CANTORDER
//
// MessageText:
//
//  The requested order could not be opened
//
  DB_E_CANTORDER                       = HResult($80040E60);

// @@@+ V2.0
//
// MessageId: MD_E_BADTUPLE
//
// MessageText:
//
//  Bad tuple
//
  MD_E_BADTUPLE                        = HResult($80040E61);

//
// MessageId: MD_E_BADCOORDINATE
//
// MessageText:
//
//  Bad coordinate
//
  MD_E_BADCOORDINATE                   = HResult($80040E62);

//
// MessageId: MD_E_INVALIDAXIS
//
// MessageText:
//
//  The given aixs was not valid for this Dataset
//
  MD_E_INVALIDAXIS                     = HResult($80040E63);

//
// MessageId: MD_E_INVALIDCELLRANGE
//
// MessageText:
//
//  One or more of the given cell ordinals was invalid
//
  MD_E_INVALIDCELLRANGE                = HResult($80040E64);

//
// MessageId: DB_E_NOCOLUMN
//
// MessageText:
//
//  The supplied columnID was invalid
//
  DB_E_NOCOLUMN                        = HResult($80040E65);

//
// MessageId: DB_E_COMMANDNOTPERSISTED
//
// MessageText:
//
//  The supplied command does not have a DBID
//
  DB_E_COMMANDNOTPERSISTED             = HResult($80040E67);

//
// MessageId: DB_E_DUPLICATEID
//
// MessageText:
//
//  The supplied DBID already exists
//
  DB_E_DUPLICATEID                     = HResult($80040E68);

//
// MessageId: DB_E_OBJECTCREATIONLIMITREACHED
//
// MessageText:
//
//  The maximum number of Sessions supported by the provider has
//  already been created. The consumer must release one or more
//  currently held Sessions before obtaining a new Session Object
//
  DB_E_OBJECTCREATIONLIMITREACHED      = HResult($80040E69);

//
// MessageId: DB_E_BADINDEXID
//
// MessageText:
//
//  The index ID is invalid
//
  DB_E_BADINDEXID                      = HResult($80040E72);

//
// MessageId: DB_E_BADINITSTRING
//
// MessageText:
//
//  The initialization string specified does not conform to specificiation
//
  DB_E_BADINITSTRING                   = HResult($80040E73);

//
// MessageId: DB_E_NOPROVIDERSREGISTERED
//
// MessageText:
//
//  The OLE DB root enumerator did not return any providers that
//  matched any of the SOURCES_TYPEs requested
//
  DB_E_NOPROVIDERSREGISTERED           = HResult($80040E74);

//
// MessageId: DB_E_MISMATCHEDPROVIDER
//
// MessageText:
//
//  The initialization string specifies a provider which does not match the currently active provider
//
  DB_E_MISMATCHEDPROVIDER              = HResult($80040E75);

//
// MessageId: SEC_E_BADTRUSTEEID
//
// MessageText:
//
//  Invalid trustee value
//
  SEC_E_BADTRUSTEEID                   = HResult($80040E6A);

//
// MessageId: SEC_E_NOTRUSTEEID
//
// MessageText:
//
//  The trustee is not for the current data source
//
  SEC_E_NOTRUSTEEID                    = HResult($80040E6B);

//
// MessageId: SEC_E_NOMEMBERSHIPSUPPORT
//
// MessageText:
//
//  The trustee does not support memberships/collections
//
  SEC_E_NOMEMBERSHIPSUPPORT            = HResult($80040E6C);

//
// MessageId: SEC_E_INVALIDOBJECT
//
// MessageText:
//
//  The object is invalid or unknown to the provider
//
  SEC_E_INVALIDOBJECT                  = HResult($80040E6D);

//
// MessageId: SEC_E_NOOWNER
//
// MessageText:
//
//  No owner exists for the object
//
  SEC_E_NOOWNER                        = HResult($80040E6E);

//
// MessageId: SEC_E_INVALIDACCESSENTRYLIST
//
// MessageText:
//
//  The access entry list supplied is invalid
//
  SEC_E_INVALIDACCESSENTRYLIST         = HResult($80040E6F);

//
// MessageId: SEC_E_INVALIDOWNER
//
// MessageText:
//
//  The trustee supplied as owner is invalid or unknown to the provider
//
  SEC_E_INVALIDOWNER                   = HResult($80040E70);

//
// MessageId: SEC_E_INVALIDACCESSENTRY
//
// MessageText:
//
//  The permission supplied in the access entry list is invalid
//
  SEC_E_INVALIDACCESSENTRY             = HResult($80040E71);

  SEC_E_PERMISSIONDENIED     = DB_SEC_E_PERMISSIONDENIED;
// @@@- V2.1

//
// MessageId: DB_S_ROWLIMITEXCEEDED
//
// MessageText:
//
//  Fetching requested number of rows would have exceeded total number
//  of active rows supported by the rowset
//
  DB_S_ROWLIMITEXCEEDED                = $00040EC0;

//
// MessageId: DB_S_COLUMNTYPEMISMATCH
//
// MessageText:
//
//  One or more column types are incompatible; conversion errors will
//  occur during copying
//
  DB_S_COLUMNTYPEMISMATCH              = $00040EC1;

//
// MessageId: DB_S_TYPEINFOOVERRIDDEN
//
// MessageText:
//
//  Parameter type information has been overridden by caller
//
  DB_S_TYPEINFOOVERRIDDEN              = $00040EC2;

//
// MessageId: DB_S_BOOKMARKSKIPPED
//
// MessageText:
//
//  Skipped bookmark for deleted or non-member row
//
  DB_S_BOOKMARKSKIPPED                 = $00040EC3;

// @@@+ V2.0
//
// MessageId: DB_S_NONEXTROWSET
//
// MessageText:
//
//  There are no more rowsets
//
  DB_S_NONEXTROWSET                    = $00040EC5;

// @@@- V2.0

//
// MessageId: DB_S_ENDOFROWSET
//
// MessageText:
//
//  Reached start or end of rowset or chapter
//
  DB_S_ENDOFROWSET                     = $00040EC6;

//
// MessageId: DB_S_COMMANDREEXECUTED
//
// MessageText:
//
//  The provider re-executed the command
//
  DB_S_COMMANDREEXECUTED               = $00040EC7;

//
// MessageId: DB_S_BUFFERFULL
//
// MessageText:
//
//  Variable data buffer full
//
  DB_S_BUFFERFULL                      = $00040EC8;

//
// MessageId: DB_S_NORESULT
//
// MessageText:
//
//  There are no more results
//
  DB_S_NORESULT                        = $00040EC9;

//
// MessageId: DB_S_CANTRELEASE
//
// MessageText:
//
//  Server cannot release or downgrade a lock until the end of the
//  transaction
//
  DB_S_CANTRELEASE                     = $00040ECA;

// @@@+ V2.5
//
// MessageId: DB_S_GOALCHANGED
//
// MessageText:
//
//  Specified weight was not supported or exceeded the supported limit
//  and was set to 0 or the supported limit
//
  DB_S_GOALCHANGED                     = $00040ECB;

// @@@- V2.5

// @@@+ V1.5
//
// MessageId: DB_S_UNWANTEDOPERATION
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this reason
//
  DB_S_UNWANTEDOPERATION               = $00040ECC;

// @@@- V1.5

//
// MessageId: DB_S_DIALECTIGNORED
//
// MessageText:
//
//  Input dialect was ignored and text was returned in different
//  dialect
//
  DB_S_DIALECTIGNORED                  = $00040ECD;

//
// MessageId: DB_S_UNWANTEDPHASE
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this phase
//
  DB_S_UNWANTEDPHASE                   = $00040ECE;

//
// MessageId: DB_S_UNWANTEDREASON
//
// MessageText:
//
//  Consumer is uninterested in receiving further notification calls for
//  this reason
//
  DB_S_UNWANTEDREASON                  = $00040ECF;

// @@@+ V1.5
//
// MessageId: DB_S_ASYNCHRONOUS
//
// MessageText:
//
//  The operation is being processed asynchronously
//
  DB_S_ASYNCHRONOUS                    = $00040ED0;

// @@@- V1.5

//
// MessageId: DB_S_COLUMNSCHANGED
//
// MessageText:
//
//  In order to reposition to the start of the rowset, the provider had
//  to reexecute the query; either the order of the columns changed or
//  columns were added to or removed from the rowset
//
  DB_S_COLUMNSCHANGED                  = $00040ED1;

//
// MessageId: DB_S_ERRORSRETURNED
//
// MessageText:
//
//  The method had some errors; errors have been returned in the error
//  array
//
  DB_S_ERRORSRETURNED                  = $00040ED2;

//
// MessageId: DB_S_BADROWHANDLE
//
// MessageText:
//
//  Invalid row handle
//
  DB_S_BADROWHANDLE                    = $00040ED3;

//
// MessageId: DB_S_DELETEDROW
//
// MessageText:
//
//  A given HROW referred to a hard-deleted row
//
  DB_S_DELETEDROW                      = $00040ED4;

// @@@+ V2.5
//
// MessageId: DB_S_TOOMANYCHANGES
//
// MessageText:
//
//  The provider was unable to keep track of all the changes; the client
//  must refetch the data associated with the watch region using another
//  method
//
  DB_S_TOOMANYCHANGES                  = $00040ED5;

// @@@- V2.5

//
// MessageId: DB_S_STOPLIMITREACHED
//
// MessageText:
//
//  Execution stopped because a resource limit has been reached; results
//  obtained so far have been returned but execution cannot be resumed
//
  DB_S_STOPLIMITREACHED                = $00040ED6;

//
// MessageId: DB_S_LOCKUPGRADED
// 
// MessageText:
// 
//  A lock was upgraded from the value specified
// 
  DB_S_LOCKUPGRADED                    = $00040ED8; 

//
// MessageId: DB_S_PROPERTIESCHANGED
//
// MessageText:
//
//  One or more properties were changed as allowed by provider
//
  DB_S_PROPERTIESCHANGED               = $00040ED9;

//
// MessageId: DB_S_ERRORSOCCURRED
//
// MessageText:
//
//  Errors occurred
//
  DB_S_ERRORSOCCURRED                  = $00040EDA;

//
// MessageId: DB_S_PARAMUNAVAILABLE
//
// MessageText:
//
//  A specified parameter was invalid
//
  DB_S_PARAMUNAVAILABLE                = $00040EDB;

//
// MessageId: DB_S_MULTIPLECHANGES
//
// MessageText:
//
//  Updating this row caused more than one row to be updated in the
//  data source
//
  DB_S_MULTIPLECHANGES                 = $00040EDC;

implementation

uses ComObj;

end.
